<?php
/********************************************************************
 * gopherclient.php - Client for parsing/displaying gopher responses
 *
 ********************************************************************/

if(!defined('GOPHERCLIENT_GENERAL_ERROR')) define('GOPHERCLIENT_GENERAL_ERROR', 'General GopherClient error');

class GopherClient
{
	var $url_prefix;

	function GopherClient($url_prefix='')
	{
		$this->url_prefix = $url_prefix;
	}

	function ParseResponse($item_type, &$response, $selector='')
	{
		global $wakka;
		if(!isset($response))
		{
			return $this->ThrowError("Need a response to parse!");
		}

		// Special handling for text and binary files 
		// (This should probably be put into its own function)
		$raw_data_item_types = array('0', '5', '9', 'g', 'I');
		$text_item_types = array('0');
		$binary_item_types = array('5', '9', 'g', 'I');
		$search_item_types = array('7');
        $image_item_types = array('g', 'I');
		if(true===in_array($item_type, $raw_data_item_types, true))
		{
			if(true===in_array($item_type, $binary_item_types, true))
			{
                echo "here";
				// We need the selector for this...
				if(!isset($selector) || '' == $selector)
				{
					return $this->ThrowError("Need the selector!");
				}
				// The following was adapted from code posted by 
				// Hillar Aarelaid at 
				// http://wikkawiki.org/FilesActionHillar
				$filename = basename($selector);
				// Override this for images that need to be displayed
				// in-browser
				$disposition = "attachment; filename=$filename";
				if (preg_match("/.*\.(\w+)$/i",$filename,$res))
					$suffix=$res[1];
				 // Search MIME Type
				 $mimefile = dirname(__FILE__).DIRECTORY_SEPARATOR.$wakka->config['mime_types'];
				if (!$suffix || $suffix=="" || !isset($mimefile)
					|| !$mimes=implode("\n", file($mimefile)))
				{
					if(true === in_array($item_type, $image_item_types, true))
					{
						$content_type = "image/gif";	
						$disposition = "inline"; 
					}
					else
						$content_type="application/octet-stream";
				}
				else 
				{
					if (preg_match("/([A-Za-z.\/-]*).*$suffix/i",$mimes,$result))
					{
						$content_type=$result[1];
						if(preg_match("/image/", $result[1]))
							$disposition = "inline";
					}
					else
					{
						$content_type="application/octet-stream";
					}
				}
				//header("Pragma: public");
				//header("Expires: 0");
				//header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
				//header("Cache-Control: public");
				//header("Content-Description: File Transfer");

				header("Content-Type: ".$content_type);
				//header('Content-Type: application/octet-stream');

				//Force the download
				header("Content-Disposition: $disposition");
				//header("Content-Transfer-Encoding: binary");
				// Header("Content-Length: ".strlen($response));
				// Header("Connection: close");
				//var_dump(headers_list());

				// Need this next line to clear out the pending output
				// from the Wikka action-handling code
				ob_clean();
				echo $response;
				exit;
			}
			else if(true===in_array($item_type, $text_item_types, true))
			{	
				$response = preg_replace('/[\r]*\n/', "<br/>\n", $response);
				$response = preg_replace('/\t/', "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;", $response);
				$response = preg_replace('/ /', "&nbsp;", $response);
				//TODO: Would be nice to write a formatter to format
				//links, mailto, etc.
				echo $response;
				return;
			}
			else
			{
				// Better check your item_type arrays...punting on 
				// this one, let's hope it can be handled...
			}	
		}

		// Explode on \r\n
		$lines = array_filter(explode("\r\n", $response));
		$last = array_pop($lines);
		// Some servers aren't returning a "." as the last line, so we 
		// just can't throw that line away
		if(0 == preg_match('/^\.$/', $last))
		{
			array_push($lines, $last);
		}

		foreach($lines as $line)
		{
			$item_type = substr($line, 0, 1);
			$fields = explode("\t", substr($line, 1));
			echo $this->FormatResponseLine($item_type, $fields);
		}
	}

	/********************************************************************
	 * fields[0] - Display string
	 * fields[1] - Selector
	 * fields[2] - Host
	 * fields[3] - Port
	 ********************************************************************/
	function FormatResponseLine($item_type, $fields)
	{
		global $wakka;
		$prefix = '';
		$image = '';
		switch((string)$item_type)
		{
		case "0":
			$prefix = "[FILE] ";
			$image = "gopher-text.gif";
			break;
		case "1":
			$prefix = "[DIR]  ";
			$image = "gopher-menu.gif";
			break;
		case "5":
		case "9":
			$prefix = "[BIN]  ";
			$image = "gopher-binary.gif";
			break;
		case "7":
			$prefix = "[SEARCH]  ";
			$image = "gopher-find.gif";
			break;
		case "i":
			$prefix = '';
			break;
		case "I":
		case "g":
			$prefix = "[IMG]  ";
			$image = "gopher-image.gif";
			break;
		default:
			$prefix = "[UNK]  ";
			$image = "gopher-unknown.gif";
			break;
		}
		$uri = rtrim($fields[2], "/");
		if(isset($fields[3]))
		{
			$uri .= ":$fields[3]";
		}
		$uri .= "/";
		$selector = ltrim($fields[1], "/");
		if(!empty($selector))
		{
			$uri .= $item_type."/"; 
			$uri .= $selector;	
		}
		$url = $this->url_prefix.$uri;
		
		if(empty($prefix))
		{
			$response = preg_replace('/\t/', "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;", $fields[0]);
			$response = preg_replace('/ /', "&nbsp;", $response);
			return $response."<br/>\n";
		}
		else
		{
            // Search item
			if(7 == $item_type)
			{
				$val = $wakka-> FormOpen();
				$val .= 
					(isset($image) ? "<img src=\"".$wakka->config['base_url'].DIRECTORY_SEPARATOR."images".DIRECTORY_SEPARATOR.$image."\">" : $prefix).
					$fields[0].
					"<input type=\"text\" name=\"q\" size=\"60\"><input type=\"submit\" value=\"Search\" name=\"search\">".
					"<input type=\"hidden\" name=\"uri\" value=\"".$uri."\">";
				$val .= $wakka->FormClose();
			}
            // HTTP link
            else if('h' == $item_type)
            {   
                preg_match("/^(url|URL):\s*(.*)$/", $fields[1], $matches);
                $val =  (isset($image) ? "<img                src=\"".$wakka->config['base_url'].DIRECTORY_SEPARATOR."images".DIRECTORY_SEPARATOR.$image."\"/>" : $prefix)."<a href=\"".$matches[2]."\">".$fields[0]."</a><br/>\n";
            }
			else
			{
				//TODO: Need to fix the image dir
				//TODO: base_url deprecated in trunk
				$val =  (isset($image) ? "<img src=\"".$wakka->config['base_url'].DIRECTORY_SEPARATOR."images".DIRECTORY_SEPARATOR.$image."\"/>" : $prefix)."<a href=\"".$url."\">".$fields[0]."</a><br/>\n";
			}
			return $val;
		}
	}

	function ThrowError($err='')
	{
		return GOPHERCLIENT_GENERAL_ERROR.": ".$err."\n";
	}

	function _dump($string, $append="false", $filename="gopherdump.txt")
	{
		if(true == $append)
			$mode = "a";
		else
			$mode = "w";
		$fp = fopen($filename, $mode);
		fwrite($fp, $string);
		fclose($fp);
	}
}
?>
