<?php
	include_once('plugins/actions/gopher/gopherclient/gopherproxy.php');
	include_once('plugins/actions/gopher/gopherclient/gopherclient.php');

    // uri_textbox overrides the uri param
    if(isset($_POST['uri_textbox']))
    {
        $uri = $this->GetSafeVar('uri_textbox', 'post');
        $vars['uri'] = $uri;
    }

    // Check for uri get param...
	else if(isset($_GET['uri']))
	{
		$vars['uri'] = $this->GetSafeVar('uri', 'get');
	}

	// Check if we have a uri post param, indicating a search form was
	// submitted.
    else if(isset($_POST['uri']))
    {
    	$uri = $this->GetSafeVar('uri', 'post');
        if(isset($uri) && '' !== $uri && null !== $uri)
        {
            $q = $this->GetSafeVar('q', 'post');
            if(isset($q) && null !== $q)
                $uri .= "?".$q;	
            $vars['uri'] = $uri;
        }
    }
    else
    {
        // Onward through the fog... 
    }

	$uri = $this->cleanURL($vars['uri']);
	// Strip protocol
	if(preg_match('/^.*\/\/(.*)$/', $uri, $matches))
	{
		$uri = $matches[1]; 
	}

	// Separate host from selector
	$selector = '';
	$item_type = '';
	$host = '';

	if(strpos($uri, "/") > 0)
	{
		$fields = explode("/", $uri, 3);
		$host = $fields[0];
		$item_type = $fields[1];
		$selector = $fields[2];
	}
	else
	{
		$host = $uri;
	}

    // In the case of a search without a selector, the selector will 
    // not exist, and needs to be set to query string
    if(!isset($selector) && isset($q))
        $selector = $q;

	if(!isset($item_type) || '' == $item_type)
	{
		$item_type = 1;
	}

	// Gopher it!
	if(!$gp = new GopherProxy($this, $host))
	{
		return;
	}
	$prefix = $this->href()."/gopher?uri=";
	$gc = new GopherClient($prefix);
	$result = $gp->ProcessRequest($selector);
	if($err = $gp->GetError())
	{
		print $err;
		exit;
	}
    // Output URI
    echo $this->FormOpen("gopher");
    echo '<div style="text-align:center">gopher://<input type="text" maxlength="150" size="50" rows="1" name="uri_textbox" value="'.$uri.'"/><input type="submit" value="Go!"/></div><br/><br/>';
    echo $this->FormClose();
	$gc->ParseResponse($item_type, $result, $selector);
?>
