/*---------------------------------------------------------------------------
QueryManager.h - Header file for QueryManager.m class.
-----------------------------------------------------------------------------*/
#import <appkit/appkit.h>

@interface QueryManager:Object
{
   id    servers;		/* List ID of the Servers objects */
   id    qiManager;		/* List ID of the Qi objects */
   id    queryList;		/* List ID of the Query objects */

   char  errMsg[256];		/* Alert panel error message string */
   int   offset;		/* Pixel offset for next Query window */
}

- init;
- initIDs:aServers qiManager:aQiManager;

- (BOOL)startQuery:(const char *)aServer;

- clearQueryFields:sender;
- clearQueryView:sender;

- getQueryId:(const char *)aServer;

@end
