/*---------------------------------------------------------------------------
QueryFieldView.m -- Copyright (c) 1991 Rex Pruess
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or send
   electronic mail to the the author.
  
This custom view contains two matrixes.  The first matrix consists of a
single column matrix containing icon-style cells.  The icon will be a
bullet for an indexed field & null for a non-indexed field.  The second
matrix is a Form containing the field forms for each of the Qi fields which
the user can use for searching.
  
Rex Pruess <Rex-Pruess@uiowa.edu>
  
$Header: /rpruess/apps/Ph/query.subproj/RCS/QueryFieldView.m,v 3.0 93/06/26 07:59:21 rpruess Exp $
-----------------------------------------------------------------------------
$Log:	QueryFieldView.m,v $
Revision 3.0  93/06/26  07:59:21  rpruess
Brought Ph code up to NeXTSTEP 3.0 specifications.

Revision 2.0  91/11/19  08:20:15  rpruess
Revision 2.0 is the initial production release of Ph.

-----------------------------------------------------------------------------*/

#define LEFTMARGIN 2.0		/* Reserved space for cosmetics */

#define ICONWIDTH   7.0		/* Bullet width */
#define ICONHEIGHT 23.0		/* Should force alignment with the form rows */

#define BETWEENMATWID 2.0	/* Space between the two matrixes */

/* Application class header files */
#import "QueryFieldView.h"

@implementation QueryFieldView

/*---------------------------------------------------------------------------
Frame initialization requires that we flip the frame so our subview alignment
is from the top instead of the bottom.  Width autosizing is enabled so the
form fields can stretch to the user's whim.  The icon matrix and the field
form matrix are created here.
-----------------------------------------------------------------------------*/
- initFrame:(const NXRect *) frameRect
{
   float           totalWidth;
   NXRect          mRect;
   NXSize          cSize;

   [super initFrame:frameRect];

   [self setFlipped:YES];
   [self setAutosizing:NX_WIDTHSIZABLE];

   /*** Create the icon matrix & set its attributes appropriately */

   NXSetRect (&mRect, LEFTMARGIN, 0.0, ICONWIDTH, (*frameRect).size.height);

   totalWidth = (*frameRect).size.width;

   iconMatrix = [[Matrix alloc] initFrame:&mRect
      mode:NX_RADIOMODE
      cellClass:[Cell class]
      numRows:0
      numCols:1];

   [iconMatrix setCellBackgroundGray:NX_LTGRAY];

   cSize.width = ICONWIDTH;
   cSize.height = ICONHEIGHT;
   [iconMatrix setCellSize:&cSize];

   mRect.origin.x += mRect.size.width + BETWEENMATWID;
   mRect.size.width = totalWidth - mRect.origin.x;

   /*** Create the field form matrix & set its attributes appropriately */

   fieldForm = [[Form alloc] initFrame:&mRect];
   [fieldForm setAutosizing:NX_WIDTHSIZABLE];

   /*** Slap the subviews onto this view; "display" is caller's duty */

   [self addSubview:iconMatrix];
   [self addSubview:fieldForm];

   return self;
}

/*---------------------------------------------------------------------------
After the matrixes have been created elsewhere, this view needs to increase
its height to reflect the size of the matrix.  The width doesn't change, but
the height will change.  If this method is not invoked, the scroller won't
appear.  There's probably a cleaner way to do this.
-----------------------------------------------------------------------------*/
- adjHeight:sender
{
   NXRect          ffRect;
   NXRect          myRect;

   [fieldForm getFrame:&ffRect];
   [self getFrame:&myRect];

   [self sizeTo:myRect.size.width:ffRect.size.height];

   return self;
}

/*---------------------------------------------------------------------------
These methods simply return the appropriate subview id.
-----------------------------------------------------------------------------*/
- fieldForm
{
   return fieldForm;
}

- iconMatrix
{
   return iconMatrix;
}

/*---------------------------------------------------------------------------
The icon matrix is not allowed to stretch.  The field form can stretch.
It's new width must be calculated each time.
-----------------------------------------------------------------------------*/
- superviewSizeChanged:(const NXSize *) oldSize
{
   NXRect          mRect;
   NXSize          cSize;

   [super superviewSizeChanged:oldSize];

   [self getFrame:&mRect];

   [fieldForm getCellSize:&cSize];

   cSize.width = mRect.size.width - LEFTMARGIN - ICONWIDTH - BETWEENMATWID;

   [fieldForm setCellSize:&cSize];

   [fieldForm sizeToCells];

   return self;
}

@end
