/*---------------------------------------------------------------------------
Site.m -- Copyright (c) 1991 Rex Pruess
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or send
   electronic mail to the the author.
  
A "ns-servers" query to the default server should return a list of
other sites running the CSO Nameserver software.  A Site object is produced
for each site.  Each Site object holds the site, server, and domain
information for that Site.
  
Rex Pruess <Rex-Pruess@uiowa.edu>
  
$Header: /rpruess/apps/Ph/qiServers.subproj/RCS/Site.m,v 3.0 93/07/02 18:46:09 rpruess Exp $
-----------------------------------------------------------------------------
$Log:	Site.m,v $
Revision 3.0  93/07/02  18:46:09  rpruess
Added code to free the servers memory since it is now assigned to "unknown"
shortly after the Site object is initialized.  (The "unknown" setting was
done to catch incomplete ns-servers entries that some sites have.)

Revision 2.1  93/06/26  07:58:01  rpruess
Brought Ph code up to NeXTSTEP 3.0 specifications.

Revision 2.0  91/11/19  08:26:50  rpruess
Revision 2.0 is the initial production release of Ph.

-----------------------------------------------------------------------------*/

/* Application class header files */
#import "Site.h"

@implementation Site

/*---------------------------------------------------------------------------
Simple initialization; force entries to empty values for safety.
-----------------------------------------------------------------------------*/
- init
{
   [super init];

   site = NULL;
   server = NULL;
   domain = NULL;

   return self;
}

/*---------------------------------------------------------------------------
Methods to set the various fields.
-----------------------------------------------------------------------------*/
- setSite:(const char *)aSite
{
   site = malloc (strlen (aSite) + 1);
   strcpy (site, aSite);

   return self;
}

- setServer:(const char *)aServer
{
   if (server != NULL)
      free (server);		/* Server is initially set to "unknown". */
   
   server = malloc (strlen (aServer) + 1);
   strcpy (server, aServer);

   return self;
}

- setDomain:(const char *)aDomain
{
   domain = malloc (strlen (aDomain) + 1);
   strcpy (domain, aDomain);

   return self;
}

/*---------------------------------------------------------------------------
Methods to return the requested data.
-----------------------------------------------------------------------------*/
- (const char *)site
{
   return site;
}

- (const char *)server
{
   return server;
}

- (const char *)domain
{
   return domain;
}

@end
