/*---------------------------------------------------------------------------
Servers.h - Header file for Servers.m class.
-----------------------------------------------------------------------------*/
#import <appkit/appkit.h>

@interface Servers:Object
{
   id    serversScrollView;	/* Servers scrollView (set by IB) */
   id    serversWindow;		/* Servers window (set by IB) */

   id    domainTextField;	/* Servers domain text field (set by IB) */
   id    serversTextField;	/* Servers text field (set by IB) */

   id    serversMatrix;		/* Matrix of servers (create by program) */
 
   id    serversMenuCell;	/* Servers menu cell */
   id    siteList;		/* List of Site objects */
   id    defaultQi;		/* Default server's Qi ID */
   id    queryManager;		/* Manager of Query objects */
   id    serversAnimator;	/* Animator ID */
   id    qiManager;		/* Manager of QiManager objects */

   int   curSite;		/* Index of current site being processed */
   char *defaultServer;		/* Name of the default CSO Nameserver */
   BOOL  hasServers;		/* Have we fetched the servers yet? */
}

- init;
- initIDs:aMenuCell queryManager:aQueryManager qiManager:aQiManager;

- fetchServers:(const char *)aServer;
- buildMatrix;

- showServersWindow:sender;

- singleClick;
- doubleClick;

- qiOutput:(char *)aBuf;
- qiOutputIsDone:sender;

- serversTimeCheck;
- startServersTimer:sender;
- stopServersTimer:sender;

- addServerSite:(const char *)aServer site:(const char *)aSite;

- (const char *)getDomainName:(const char *)aServer;
- (const char *)getServerName:(const char *)aSite;
- (const char *)getSiteName:(const char *)aServer;
- getServersAndSites:(char **)serverNames sites:(char **)siteNames;

- (BOOL)hasServers;

@end
