/*---------------------------------------------------------------------------
QiManager.m -- Copyright (c) 1991 Rex Pruess
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or send
   electronic mail to the the author.
  
There is just one QiManager object.  For each unique server, QiManager
creates a Qi object which in turn attemps to connect a socket with that
server.  Thus, no matter how many query or edit windows are up for a
specific server, there will be just one network socket connection with that
server.
  
Rex Pruess <Rex-Pruess@uiowa.edu>
  
$Header: /rpruess/apps/Ph/qiServers.subproj/RCS/QiManager.m,v 3.0 93/06/26 07:57:54 rpruess Exp $
-----------------------------------------------------------------------------
$Log:	QiManager.m,v $
Revision 3.0  93/06/26  07:57:54  rpruess
Brought Ph code up to NeXTSTEP 3.0 specifications.

Revision 2.0  91/11/19  08:26:12  rpruess
Revision 2.0 is the initial production release of Ph.

-----------------------------------------------------------------------------*/

/* Application class header files */
#import "QiManager.h"
#import "Qi.h"

@implementation QiManager

/*---------------------------------------------------------------------------
Allocate our list to keep track of the Qi objects (i.e., servers).
-----------------------------------------------------------------------------*/
- init
{
   [super init];

   qiList = [[List alloc] init];
   return self;
}

/*---------------------------------------------------------------------------
If we do not already have a Qi object (i.e., server socket), then create the
Qi object and try to form a connection with the Qi server.
-----------------------------------------------------------------------------*/
- open:(const char *)aServer;
{
   int             i;
   int             nItems;
   id              theQi;

   theQi = nil;

   /*** See if we already have a Qi object for this server. */

   nItems = [qiList count];
   for (i = 0; i < nItems; i++) {
      if (strcmp ([[qiList objectAt:i] server], aServer) == 0)
	 return [qiList objectAt:i];
   }

   /*** Create the Qi object & tell it to set up the socket connection. */

   theQi = [[Qi alloc] init];

   if ([theQi connectTo:aServer] == NO) {
      [theQi free];
      return nil;
   }

   [qiList addObjectIfAbsent:theQi];

   return theQi;
}

/*---------------------------------------------------------------------------
Tell all the Qi servers to quit.
-----------------------------------------------------------------------------*/
- quitServers
{
   [qiList makeObjectsPerform:@selector (quit)];

   return self;
}

@end
