/*---------------------------------------------------------------------------
QiField.m -- Copyright (c) 1991 Rex Pruess
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or send
   electronic mail to the the author.
  
A QiField object contains the number, name, keywords, and description for a
single field.
        Example:   number = field number
	             name = high_school
                 keywords = max 30 Indexed Lookup Public Change
               descripton = high school attended
  
QiField objects are create by Qi objects.  Each Qi object has the duty
to find all the fields from its server.  The field information is referred
to often so we need to hang on to it.  It is not wise to bother the server
any more than necessary.
  
Rex Pruess <Rex-Pruess@uiowa.edu>
  
$Header: /rpruess/apps/Ph/qiServers.subproj/RCS/QiField.m,v 3.0 93/06/26 07:56:42 rpruess Exp $
-----------------------------------------------------------------------------
$Log:	QiField.m,v $
Revision 3.0  93/06/26  07:56:42  rpruess
Brought Ph code up to NeXTSTEP 3.0 specifications.

Revision 2.0  91/11/19  08:25:27  rpruess
Revision 2.0 is the initial production release of Ph.

-----------------------------------------------------------------------------*/

/* Application class header files */
#import "QiField.h"

@implementation QiField

/*---------------------------------------------------------------------------
Simple initialiazation; force entries to empty values for safety.
-----------------------------------------------------------------------------*/
- init
{
   [super init];

   number = -1;
   name = NULL;
   keywords = NULL;
   description = NULL;

   return self;
}

/*---------------------------------------------------------------------------
Methods to set the various fields.
-----------------------------------------------------------------------------*/
- setNumNameKeys:(const int)aNumber name:(const char *)aName keys:(const char *)theKeywords
{
   number = aNumber;

   name = malloc (strlen (aName) + 1);
   strcpy (name, aName);

   keywords = malloc (strlen (theKeywords) + 1);
   strcpy (keywords, theKeywords);

   return self;
}

- setDescription:(const char *)aDescription
{
   description = malloc (strlen (aDescription) + 1);
   strcpy (description, aDescription);

   return self;
}

/*---------------------------------------------------------------------------
Methods to return the requested data.
-----------------------------------------------------------------------------*/
- (int)number
{
   return number;
}

- (const char *)name
{
   return name;
}

- (const char *)keywords
{
   return keywords;
}

- (const char *)description
{
   return description;
}

@end
