/*---------------------------------------------------------------------------
InfoView.m -- Copyright (c) 1991 Rex Pruess
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or send
   electronic mail to the the author.
  
Info panels are often dull.  This one throws in a little animation for the
fun of it.  Two images are alternated to give the appearance of walking
fingers.
  
Rex Pruess <Rex-Pruess@uiowa.edu>
  
$Header: /rpruess/apps/Ph/info.subproj/RCS/InfoView.m,v 3.0 93/06/26 07:59:59 rpruess Exp $
-----------------------------------------------------------------------------
$Log:	InfoView.m,v $
Revision 3.0  93/06/26  07:59:59  rpruess
Brought Ph code up to NeXTSTEP 3.0 specifications.

Revision 2.0  91/11/18  17:49:54  rpruess
Revision 2.0 is the initial production release of Ph.

-----------------------------------------------------------------------------*/

/* Application class header files */
#import "InfoView.h"
#import "Animator.h"

@implementation InfoView

/*---------------------------------------------------------------------------
Create the animator object for later use.  Initialize the images that we
will need for the animation.
-----------------------------------------------------------------------------*/
- initFrame:(const NXRect *) frm
{
   [super initFrame:frm];

   infoAnimator = [[Animator alloc] initChronon:0.0
      adaptation:0.0
      target:self
      action:@selector (drawImages)
      autoStart :NO
      eventMask:0];

   fingersIn = [NXImage findImageNamed:"Ph"];
   fingersOut = [NXImage findImageNamed:"FingersIn"];

   return self;
}

/*---------------------------------------------------------------------------
This routine is driven by the animator.  The two images are alternated to
give the appearance of moving fingers.
-----------------------------------------------------------------------------*/
- drawImages
{
   if (++nDrawPasses == 2)
      sleep (1);		/* Pause on 2nd pass (ie, prior to animation) */

   [self lockFocus];

   /*** This code assumes that all images are the same size. */

   switch (nDrawPasses > DRAWTIMES) {
   case NO:
      PSsetgray (NX_LTGRAY);
      NXRectFill (&bounds);

      if (nDrawPasses % 2 == 0)
         [fingersOut composite:NX_SOVER toPoint:&bounds.origin];
      else
         [fingersIn composite:NX_SOVER toPoint:&bounds.origin];

      break;

   case YES:
      drawnOnce = YES;
      drawing = NO;
      [self stopInfoViewTimer:self];

      break;
   }

   [[self window] flushWindow];
   [self unlockFocus];

   return (self);
}

/*---------------------------------------------------------------------------
This is the initial drawing method.  It sets up starting values & brings the
animator to life.
-----------------------------------------------------------------------------*/
- drawInit:sender
{
   drawnOnce = NO;
   nDrawPasses = 0;

   [self startInfoViewTimer:.1];

   drawing = YES;

   return self;
}

/*---------------------------------------------------------------------------
Every good view has a draw self.
-----------------------------------------------------------------------------*/
- drawSelf:(const NXRect *) r :(int)c
{
   PSsetgray (NX_LTGRAY);
   NXRectFill (&bounds);
   return (self);
}

/*---------------------------------------------------------------------------
Methods to start up & stop the animator.
-----------------------------------------------------------------------------*/
- startInfoViewTimer:(float)seconds
{
   [infoAnimator setIncrement:seconds];
   [infoAnimator startEntry];

   return self;
}

- stopInfoViewTimer:sender
{
   [infoAnimator stopEntry];
   return self;
}

/*---------------------------------------------------------------------------
If the user clicks inside the view, then start the animation all over again.
-----------------------------------------------------------------------------*/
- mouseDown:(NXEvent *) theEvent
{
   if (drawnOnce)
      [self drawInit:self];

   return (self);
}

/*---------------------------------------------------------------------------
This is the magic that starts everything up.  If the window comes to life,
then begin the show.
-----------------------------------------------------------------------------*/
- windowDidBecomeKey:sender
{

   if (!(drawnOnce || drawing))
      [self drawInit:self];

   return (self);
}

/*---------------------------------------------------------------------------
If the window is going bye-bye, then stop the show.
-----------------------------------------------------------------------------*/
- windowWillClose:sender
{
   if (drawing)
      [self stopInfoViewTimer:self];

   drawing = drawnOnce = NO;

   [self lockFocus];
   [self drawSelf:0 :0];
   [self unlockFocus];

   return self;
}


@end
