/*---------------------------------------------------------------------------
InfoView.h - Header file for InfoView.m class.
-----------------------------------------------------------------------------*/

#define DRAWTIMES 25           /* Must be odd number to end with right image */

#include <appkit/appkit.h>

@interface InfoView:View
{
   id infoAnimator;		/* Animator object */

   id fingersIn;		/* Fingers together */
   id fingersOut;		/* Fingers spread */

   int nDrawPasses;		/* Number of drawing passes */
   
   BOOL drawnOnce;		/* Has the image been drawn once */
   BOOL drawing;		/* Are we currently drawing? */
}

- initFrame:(const NXRect *)frm;

- drawImages;
- drawInit:sender;

- mouseDown:(NXEvent *)theEvent;

- startInfoViewTimer:(float)seconds;
- stopInfoViewTimer:sender;

- windowDidBecomeKey:sender;
- windowWillClose:sender;

@end
