/*---------------------------------------------------------------------------
HelpServerMgr.m -- Copyright (c) 1991 Rex Pruess

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or send
   electronic mail to the the author.

This code manages the HelpServer objects.  There is only one HelpServerMgr
object.

Rex Pruess <Rex-Pruess@uiowa.edu>

$Header: /rpruess/apps/Ph/info.subproj/RCS/HelpServerMgr.m,v 3.0 93/06/26 07:59:55 rpruess Exp $
-----------------------------------------------------------------------------
$Log:	HelpServerMgr.m,v $
Revision 3.0  93/06/26  07:59:55  rpruess
Brought Ph code up to NeXTSTEP 3.0 specifications.

Revision 2.0  91/11/18  17:48:51  rpruess
Revision 2.0 is the initial production release of Ph.

-----------------------------------------------------------------------------*/
/* Help class header file */
#import "HelpServerMgr.h"
#import "HelpServer.h"

@implementation HelpServerMgr

- init
{
   self = [super init];

   helpServerList = [[List alloc] init];
   return self;
}

- showServerHelp:(const char *)aServer site:(const char *)aSite qi:aQi
{
   int             i;
   int             nItems;
   id              theHelpServer;

   theHelpServer = nil;

   /*** See if we already have a HelpServer object for this server. */

   nItems = [helpServerList count];
   for (i = 0; i < nItems; i++) {

      if (strcmp ([[helpServerList objectAt:i] server], aServer) == 0) {
	 [[helpServerList objectAt:i] showHelpWindow:self];
	 return self;
      }
      
   }

   /*** Create the HelpServer object. */

   theHelpServer = [[HelpServer alloc] init];
   [theHelpServer initData:aServer site:aSite qi:aQi];
   
   [helpServerList addObjectIfAbsent:theHelpServer];

   return self;
}

@end
