/*---------------------------------------------------------------------------
HelpServer.h - Header file for HelpServer.m class.
-----------------------------------------------------------------------------*/
#define MAXTOPICS 500		/* Only needed for isRtf matrix  */

#import <appkit/appkit.h>

@interface HelpServer:Object
{
   id    helpServerWindow;	/* Help window for this server */
   id    dataScrollView;	/* Help output data from the server */
   id    matrixScrollView;	/* Selection matrix of Server help items */
   id    splitView;		/* View encompassing matrixView & dataView */

   BOOL  amBusy;		/* Busy processing help data? */
   int   curHelpNum;		/* Assumptions: nextph=1 & native=2 */
   id    cellMsgFont;           /* Font for the cell separator messages */
   id    helpMatrix;		/* Server's list of help items */
   BOOL  isRtf[MAXTOPICS];	/* Is the help entry "rich text format"? */
   int   lineNum;		/* Current number of data line */
   int   nativeRow;		/* Row number where "native" topics begin */
   int   nRows;			/* Number of rows in helpMatrix */
   id    qi;			/* Qi object for this server */
   BOOL  readingTopics;		/* Are we still fetching the help topics? */
   int   selRow;		/* Currently selected row. */
   char *server;		/* Server's name */
   BOOL  stripRtf;		/* Strip column one in each RTF line? */
   
   NXStream *helpStream;	/* Help data memory stream */
}

- init;
- createFont:sender;
- initData:(const char *)aServer site:(const char *)aSite qi:aQi;

- qiOutput:(char *)aBuf;
- qiOutputDone:sender;
- processHelpLine:(char *)aBuf;
- processDataLine:(char *)aBuf;

- singleClick;

- outputErr:(char *)aString;
- outputStream:sender;

- clearData:sender;

- showHelpWindow:sender;
- splitView:sender getMinY:(NXCoord *) minY maxY:(NXCoord *) maxY  ofSubviewAt:(int)offset;
- splitView:sender resizeSubviews:(const NXSize *) oldSize;

- (const char *)server;

@end
