use std::io::{self, Read};
use std::sync::mpsc;
use std::thread;
use std::time::Duration;

fn read_stdin_with_timeout() -> Option<String> {
    let (chan_send, chan_receive) = mpsc::channel();

    // Creating a thread and then doing recv_timeout() is apparently "the way to go" to get a
    // read() with a timeout.

    thread::spawn(move || {
        let mut buf: [u8; 1000] = [0; 1000];
        let mut single: [u8; 1] = [0; 1];
        let mut got: usize = 0;

        while got < buf.len() && single[0] != b'\n' {
            let res = io::stdin().read(&mut single);
            if res.is_err() {
                chan_send.send(None).unwrap();
                return;
            }

            if res.unwrap() == 0 {
                break;
            }

            buf[got] = single[0];
            got += 1;
        }

        let buf = &buf[..got];

        chan_send
            .send(Some(
                String::from_utf8_lossy(buf).into_owned().trim().to_string(),
            ))
            .unwrap();
    });

    chan_receive
        .recv_timeout(Duration::from_secs(15))
        .unwrap_or_default()
}

pub fn read_input() -> Option<(String, String)> {
    match read_stdin_with_timeout() {
        Some(input) => match input.split_once("\t") {
            None => Some((input, String::from(""))),
            Some((a, b)) => Some((a.trim().to_string(), b.trim().to_string())),
        },
        None => None,
    }
}
