use std::env::{home_dir, var};
use std::fs::read_to_string;
use std::path::PathBuf;

pub fn load() -> Result<Vec<String>, String> {
    let base_dir = match var("XDG_CONFIG_HOME") {
        Ok(val) => PathBuf::from(val),
        Err(_) => home_dir()
            .expect("No idea what your homedir is")
            .join(".config"),
    };
    let cfg_file = base_dir.join("rophcatch.urls");

    if let Ok(content) = read_to_string(&cfg_file) {
        Ok(content
            .lines()
            .map(str::trim)
            .map(String::from)
            .filter(|s| !s.is_empty() && !s.starts_with('#'))
            .collect())
    } else {
        Err(format!(
            "Could not read config file [{}]",
            cfg_file.display()
        ))
    }
}
