/*
 * AppletIcon.java - Applet Icon v 0.5
 * Copyright (C) 2000 VERHILLE Arnaud
 * gist@wanadoo.fr
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

import java.awt.*;

public class AppletIcon extends java.applet.Applet implements Runnable {

        Thread runner = null;
        Image offScrImg;
        Font font;
        int charTableLength;
        char [] charTable; // Message sous forme de tableau de charactres
        boolean [] majTable; // si true alors lettre en Majuscule
        Color backgroundColor;

        public void init() { // Initialisation de l'applet
                Integer redLevel, greenLevel, blueLevel; // Recuperation des Paramtres
                String message;
                int red, green, blue;
                message = getParameter ("texte");
                if (message == null) {
                        message = "Applet";
                }
                charTableLength = message.length();
                try {
                        redLevel = new Integer (getParameter ("redLevel"));
                        greenLevel = new Integer (getParameter ("greenLevel"));
                        blueLevel = new Integer (getParameter ("blueLevel"));
                        red = redLevel.intValue();
                        green = greenLevel.intValue();
                        blue = blueLevel.intValue();
                } catch (Exception e) { // Background color par defaut
                        red = 51;
                        green = 51;
                        blue = 153;
                }

                charTable = new char[charTableLength]; // Assigne les paramtres
                majTable = new boolean[charTableLength];
                for (int i = 0 ; i < charTableLength; i++) {
                        charTable[i] = message.charAt(i);
                        if (Character.isUpperCase(charTable[i])) { // Creation de la table de maj
                                majTable[i] = true;
                        } else {
                                majTable[i] = false;
                        }
                }
                backgroundColor = new Color(red, green, blue);
                font = new Font ("TimesRoman",Font.BOLD, 25);
        }

        public void start() { // Thread methods
                runner = new Thread(this);
                runner.start();
        }
        public synchronized void stop() {
                runner = null;
                notify();
        }
        public void run() {
                for (;;) {
                        try {
                                runner.sleep(100);
                        } catch (Exception e) {}
                        repaint();
                }
        }
        public void update (Graphics gc) {
                 if (offScrImg == null) // Double Buffering :-)
                        offScrImg = createImage(size().width, size().height);
                Graphics og = offScrImg.getGraphics();
                paint(og);
                gc.drawImage(offScrImg,0,0,this);
                og.dispose();
                }
        public void paint(Graphics gc) {                
                String fontStyle;
                int largeurCharac = 0;
                int positionX = 2;

                gc.setColor (backgroundColor);
                gc.fillRect (0, 0, size().width, size().height);

                gc.setColor(Color.white);
                for (int i = 0 ; i < charTableLength ; i++) { // Choix hazard de la font
                        int s = (int)(15 * Math.random() + 10);
                        int s2 = (int)(5 * Math.random());
                        switch (s2) {
                        case 1 :
                                fontStyle = "TimesRoman";
                                break;
                        case 2 :
                                fontStyle = "Dialog";
                                break;
                        case 3 :
                                fontStyle = "Helvetica";
                                break;
                        case 4 :
                                fontStyle = "Courier";
                                break;
                        case 5 :
                                fontStyle = "Symbol";
                                break;
                        default :
                                fontStyle = "TimesRoman";
                        }
                        font = new Font (fontStyle, Font.BOLD, s);
                        gc.setFont(font);
                        if (majTable[i]) {
                                largeurCharac = 18;
                        } else {
                                largeurCharac = 15;
                        }
                        gc.drawChars(charTable, i, 1, positionX, 28);
                        positionX += largeurCharac;
                }
        }
        public String getAppletInfo() {
                return "Title: AppletIcon 0.4\nAuthor: Verhille Arnaud, 2000 \nMoving/Resizing Text";
        }
        public String[][] getParameterInfo() {
                String[][] info = { {"redLevel", "int (0-255)",
                "Background red Level (default : 51)"}, {"greenLevel",
                "int (0-255)",
                "Background green Level (default : 51)"}, {"blueLevel",
                "int (0-255)",
                "Background blue Level (default : 153)"}, {"texte",
                "String", "Text display (default : Applet)"} };
                return info;
        }
}
