/*
 * AppleChar.java - Apple .vid viewer v 1.2
 * Copyright (C) 2000,2001 VERHILLE Arnaud
 * gist@wanadoo.fr
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

import java.awt.*;
import java.io.InputStream;
import java.io.DataInputStream;
import java.net.URL;

public class AppleChar extends java.applet.Applet {
    
    byte[] characTable;
    int characTablePointer;
    byte[] charac;
    static final int PIXELSIZE = 8;
    int xPosition = 160;
    int yPosition = 70;

    public void init() {
	charac = new byte[8];
	if (getParameter ("filename") != null) {
	    readUrlFile(getParameter("filename"));
	} else {
	    readUrlFile("apple1.vid");
	}
	if (getParameter ("characNumber") != null) {
	    characTablePointer =  ((new Integer (getParameter("characNumber"))).intValue());
	} else  {
	    characTablePointer = 0x00;
	}		
	newCharac (characTablePointer);
    }
    public void paint (Graphics g) {

	g.setColor(Color.black);
	g.fillRect (0, 0, size().width, size().height);

	g.setColor(Color.green);
	g.drawString("Address : 0x"+Long.toHexString(characTablePointer * 8).toUpperCase() + "     Character n 0x"+ Long.toHexString(characTablePointer).toUpperCase() + "  bytes :",2, 10);
	int i, j;
	for (i = 0; i < 8 ; i++) {
	    g.drawString("0x"+ Long.toHexString((charac[i] & 0xFF)).toUpperCase(),15 + 35 * i , 25);

	    for (j = 0; j < 8 ; j++) {
		if ((charac[i] & (0x01 << j)) == (0x01 << j)) {
		    g.drawString("1", 40 + 10 * j,50 + 15 * i);
		    g.fillRect (xPosition +PIXELSIZE * j,yPosition + PIXELSIZE * i,PIXELSIZE, PIXELSIZE);
		} else
		    g.drawString("0", 40 + 10 * j,50 + 15 * i);
	    }
	}
    }
    public void readUrlFile (String filename) {
	DataInputStream fis = null;
	try {
	    URL u = new URL(getCodeBase(), filename);
	    fis = new DataInputStream (u.openStream());
	    int fileLength = fis.available();
	    int i;
	    characTable = new byte[fileLength];
	    for (i = 0 ; i < fileLength; i++)
		characTable[i] = fis.readByte();
	    System.out.println((i/8)+" / "+(fileLength/8)+" characters loaded"); 
	} catch (Exception e) {
	    System.out.println(e);
	    return;
	}
    }
    public void newCharac (int characTablePointer) {
	int i;
	for (i = 0 ; i < 8 ; i++)
	    charac[i] = characTable[characTablePointer * 8 + i];
    }
    synchronized public boolean mouseDown (Event e, int x, int y) {
	characTablePointer++;
	if (characTablePointer * 8 + 1 > characTable.length)
	    characTablePointer = 0;
	newCharac (characTablePointer);
	repaint();
	return true;
    }
}
