/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.input;

import com.bytezone.input.InputPanel;
import com.bytezone.input.SpringUtilities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;

public class TextPanel
extends InputPanel
implements Iterable<JTextField> {
    private final List<JTextField> textFields = new ArrayList<JTextField>();

    public TextPanel(String[] labels) {
        this.init(labels);
    }

    public TextPanel(String title, String[] labels) {
        super(title);
        this.init(labels);
    }

    protected void init(String[] labels) {
        int i = 0;
        while (i < labels.length) {
            this.setLabel(labels[i]);
            JTextField tf = labels[i].equals("Password") ? new JPasswordField(TEXT_LENGTH) : new JTextField(TEXT_LENGTH);
            this.textFields.add(tf);
            this.add(tf);
            tf.setName(labels[i]);
            ++i;
        }
        SpringUtilities.makeCompactGrid(this, labels.length, 2, OFFSET, OFFSET, GAP, GAP);
    }

    public void setText(int index, String text) {
        this.textFields.get(index).setText(text);
    }

    public void setText(String label, String text) {
        for (JTextField textField : this.textFields) {
            if (!textField.getName().equals(label)) continue;
            textField.setText(text);
            break;
        }
    }

    public String getText() {
        return this.textFields.size() == 1 ? this.textFields.get(0).getText() : null;
    }

    public String getText(int index) {
        return this.textFields.get(index).getText();
    }

    public String getText(String label) {
        JTextField tf = this.getItem(label);
        return tf == null ? null : tf.getText();
    }

    public JTextField getItem(int index) {
        return this.textFields.get(index);
    }

    public JTextField getItem(String label) {
        for (JTextField textField : this.textFields) {
            if (!textField.getName().equals(label)) continue;
            return textField;
        }
        return null;
    }

    public void addDocumentListener(DocumentListener listener) {
        for (JTextField field : this.textFields) {
            field.getDocument().addDocumentListener(listener);
        }
    }

    @Override
    public Iterator<JTextField> iterator() {
        return this.textFields.iterator();
    }
}

