/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.input;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SpringLayout;

public abstract class InputPanel
extends JComponent {
    protected static Dimension LABEL_SIZE = new Dimension(80, 15);
    protected static Dimension BUTTON_SIZE = new Dimension(80, 30);
    protected static int TEXT_LENGTH = 20;
    protected static int OFFSET = 5;
    protected static int GAP = 5;

    public InputPanel() {
        this.setLayout(new SpringLayout());
    }

    public InputPanel(String title) {
        this();
        this.setBorder(BorderFactory.createTitledBorder(title));
    }

    public void lock() {
        Dimension size = this.getSize();
        this.setMinimumSize(size);
        this.setPreferredSize(size);
        this.setMaximumSize(size);
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof InputPanel) {
                ((InputPanel)c).lock();
            } else {
                size = c.getSize();
                c.setMinimumSize(size);
                c.setPreferredSize(size);
                c.setMaximumSize(size);
            }
            ++n2;
        }
    }

    protected JLabel setLabel(String labelText) {
        return this.setLabel(labelText, 0);
    }

    protected JLabel setLabel(String labelText, int alignment) {
        JLabel label = new JLabel(String.valueOf(labelText) + " ", 11);
        this.add(label);
        label.setPreferredSize(LABEL_SIZE);
        label.setMaximumSize(LABEL_SIZE);
        label.setVerticalAlignment(alignment);
        return label;
    }

    public static void setLabelWidth(int width) {
        LABEL_SIZE = new Dimension(width, 15);
    }

    public static void setButtonSize(Dimension dimension) {
        BUTTON_SIZE = dimension;
    }

    public static void setTextLength(int length) {
        TEXT_LENGTH = length;
    }

    public static void setOffset(int length) {
        OFFSET = length;
    }

    public static void setGap(int length) {
        GAP = length;
    }
}

