/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.input;

import com.bytezone.input.InputPanel;
import com.bytezone.input.SpringUtilities;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class CheckBoxPanel
extends InputPanel
implements Iterable<JCheckBox> {
    private final List<JCheckBox> buttons = new ArrayList<JCheckBox>();

    public CheckBoxPanel(String labelText, String[] options) {
        this.init(labelText, options);
    }

    public CheckBoxPanel(String title, String labelText, String[] options) {
        super(title);
        this.init(labelText, options);
    }

    public CheckBoxPanel(String labelText, String[][] options) {
        this.initByColumn(labelText, options);
    }

    public CheckBoxPanel(String title, String labelText, String[][] options) {
        super(title);
        this.initByColumn(labelText, options);
    }

    protected void init(String labelText, String[] options) {
        this.setLabel(labelText);
        int i = 0;
        while (i < options.length) {
            JCheckBox cb = new JCheckBox(options[i]);
            this.add(cb);
            this.buttons.add(cb);
            ++i;
        }
        SpringUtilities.makeCompactGrid(this, 1, options.length + 1, OFFSET, OFFSET, GAP, GAP);
    }

    protected void initByRow(String labelText, String[][] options) {
        int i = 0;
        while (i < options.length) {
            this.setLabel(i == 0 ? labelText : "");
            int j = 0;
            while (j < options[0].length) {
                if (j < options[i].length) {
                    JCheckBox cb = new JCheckBox(options[i][j]);
                    this.add(cb);
                    this.buttons.add(cb);
                } else {
                    this.add(new JLabel(""));
                }
                ++j;
            }
            ++i;
        }
        SpringUtilities.makeCompactGrid(this, options.length, options[0].length + 1, OFFSET, OFFSET, GAP, GAP);
    }

    protected void initByColumn(String labelText, String[][] options) {
        int j = 0;
        while (j < options[0].length) {
            this.setLabel(j == 0 ? labelText : "");
            int i = 0;
            while (i < options.length) {
                if (j < options[i].length) {
                    JCheckBox cb = new JCheckBox(options[i][j]);
                    this.add(cb);
                    this.buttons.add(cb);
                } else {
                    this.add(new JLabel(""));
                }
                ++i;
            }
            ++j;
        }
        SpringUtilities.makeCompactGrid(this, options[0].length, options.length + 1, OFFSET, OFFSET, GAP, GAP);
    }

    public void setSelected(String name) {
        for (JCheckBox button : this.buttons) {
            if (!button.getText().equals(name)) continue;
            button.setSelected(true);
            break;
        }
    }

    public JCheckBox getItem(String name) {
        for (JCheckBox button : this.buttons) {
            if (!button.getText().equals(name)) continue;
            return button;
        }
        return null;
    }

    public void addActionListener(ActionListener listener) {
        for (JCheckBox button : this.buttons) {
            button.addActionListener(listener);
        }
    }

    @Override
    public Iterator<JCheckBox> iterator() {
        return this.buttons.iterator();
    }
}

