/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.wizardry;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.disk.AppleDisk;
import com.bytezone.diskbrowser.disk.DefaultAppleFileSource;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.pascal.FileEntry;
import com.bytezone.diskbrowser.pascal.PascalDisk;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;
import com.bytezone.diskbrowser.wizardry.Header;
import com.bytezone.diskbrowser.wizardry.Huffman;
import com.bytezone.diskbrowser.wizardry.MazeGridV5;
import com.bytezone.diskbrowser.wizardry.MazeLevel;
import com.bytezone.diskbrowser.wizardry.MessageBlock;
import com.bytezone.diskbrowser.wizardry.MessageDataBlock;
import com.bytezone.diskbrowser.wizardry.Relocator;
import com.bytezone.diskbrowser.wizardry.Wiz4Image;
import com.bytezone.diskbrowser.wizardry.Wiz4Monsters;
import com.bytezone.diskbrowser.wizardry.Wiz5Monsters;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class Wizardry4BootDisk
extends PascalDisk {
    public Header scenarioHeader;
    private Relocator relocator;
    private MessageBlock messageBlock;
    private Huffman huffman;
    private final int version;

    public Wizardry4BootDisk(AppleDisk[] dataDisks) {
        super(dataDisks[0]);
        DefaultMutableTreeNode monstersNode;
        DefaultMutableTreeNode scenarioNode;
        DefaultMutableTreeNode messagesNode;
        DefaultMutableTreeNode huffNode;
        DefaultMutableTreeNode pascalNode;
        this.version = dataDisks.length == 6 ? 4 : (dataDisks.length == 10 ? 5 : 0);
        DefaultTreeModel model = (DefaultTreeModel)this.catalogTree.getModel();
        DefaultMutableTreeNode currentRoot = (DefaultMutableTreeNode)model.getRoot();
        DefaultMutableTreeNode relocNode = this.findNode(currentRoot, "SYSTEM.RELOC");
        FileEntry fileEntry = (FileEntry)relocNode.getUserObject();
        if (fileEntry != null) {
            this.relocator = new Relocator(fileEntry.getUniqueName(), fileEntry.getDataSource().buffer);
            this.relocator.createNewBuffer(dataDisks);
            fileEntry.setFile(this.relocator);
        }
        if ((fileEntry = (FileEntry)(pascalNode = this.findNode(currentRoot, "SYSTEM.PASCAL")).getUserObject()) != null) {
            fileEntry.setFile(null);
            fileEntry.getDataSource();
        }
        if ((fileEntry = (FileEntry)(huffNode = this.findNode(currentRoot, "ASCII.HUFF")).getUserObject()) != null) {
            byte[] buffer = fileEntry.getDataSource().buffer;
            this.huffman = new Huffman("Huffman tree", buffer);
            fileEntry.setFile(this.huffman);
        }
        if ((fileEntry = (FileEntry)(messagesNode = this.findNode(currentRoot, "ASCII.KRN")).getUserObject()) != null) {
            this.messageBlock = new MessageBlock(fileEntry.getDataSource().buffer, this.huffman);
            fileEntry.setFile(this.messageBlock);
            messagesNode.setAllowsChildren(true);
            List blocks = fileEntry.getSectors();
            int count = 0;
            for (MessageDataBlock mdb : this.messageBlock) {
                ArrayList<DiskAddress> messageBlocks = new ArrayList<DiskAddress>();
                messageBlocks.add((DiskAddress)blocks.get(count++));
                this.addToNode(mdb, messagesNode, messageBlocks);
            }
        }
        if (this.version == 4) {
            scenarioNode = this.findNode(currentRoot, "SCENARIO.DATA");
            fileEntry = (FileEntry)scenarioNode.getUserObject();
            if (fileEntry != null) {
                fileEntry.setFile(null);
                scenarioNode.setAllowsChildren(true);
                this.scenarioHeader = new Header(scenarioNode, this);
                this.linkMazeLevels4(scenarioNode, fileEntry);
            }
        } else if (this.version == 5 && (fileEntry = (FileEntry)(scenarioNode = this.findNode(currentRoot, "DRAGON.DATA")).getUserObject()) != null) {
            fileEntry.setFile(null);
            scenarioNode.setAllowsChildren(true);
            this.linkMazeLevels5(scenarioNode, fileEntry);
            this.linkBlock1(scenarioNode, fileEntry);
            this.linkOracle(scenarioNode, fileEntry);
            this.linkBlock2(scenarioNode, fileEntry);
        }
        if (this.version == 4) {
            monstersNode = this.findNode(currentRoot, "200.MONSTERS");
            fileEntry = (FileEntry)monstersNode.getUserObject();
            if (fileEntry != null) {
                monstersNode.setAllowsChildren(true);
                this.linkMonsterImages4(monstersNode, fileEntry);
            }
        } else if (this.version == 5 && (fileEntry = (FileEntry)(monstersNode = this.findNode(currentRoot, "200.MONSTERS")).getUserObject()) != null) {
            monstersNode.setAllowsChildren(true);
            this.linkMonsterImages5(monstersNode, fileEntry);
        }
    }

    private void linkMonsterImages4(DefaultMutableTreeNode monstersNode, FileEntry fileEntry) {
        List pictureBlocks = fileEntry.getSectors();
        Wiz4Monsters w4monsters = new Wiz4Monsters("monsters", fileEntry.getDataSource().buffer);
        fileEntry.setFile(w4monsters);
        int count = 0;
        for (Wiz4Image image : w4monsters.images) {
            ArrayList<DiskAddress> monsterBlocks = new ArrayList<DiskAddress>();
            monsterBlocks.add((DiskAddress)pictureBlocks.get(w4monsters.blocks.get(count++)));
            this.addToNode(image, monstersNode, monsterBlocks);
        }
    }

    private void linkMonsterImages5(DefaultMutableTreeNode monstersNode, FileEntry fileEntry) {
        List pictureBlocks = fileEntry.getSectors();
        Wiz5Monsters w5monsters = new Wiz5Monsters("monsters", fileEntry.getDataSource().buffer);
        fileEntry.setFile(w5monsters);
        for (Wiz5Monsters.Monster monster : w5monsters) {
            ArrayList<DiskAddress> monsterBlocks = new ArrayList<DiskAddress>();
            for (Integer blockId : monster.getBlocks()) {
                monsterBlocks.add((DiskAddress)pictureBlocks.get(blockId));
            }
            this.addToNode(monster.getImage(), monstersNode, monsterBlocks);
        }
    }

    private void linkMazeLevels4(DefaultMutableTreeNode scenarioNode, FileEntry fileEntry) {
        Header.ScenarioData mazeData = this.scenarioHeader.data.get(1);
        byte[] buffer = fileEntry.getDataSource().buffer;
        List blocks = fileEntry.getSectors();
        DefaultMutableTreeNode mazeNode = this.linkNode("Maze", "Levels string", scenarioNode);
        int i = 0;
        while (i < 15) {
            byte[] level = new byte[896];
            int offset = mazeData.dataOffset * 512 + i * 1024;
            System.arraycopy(buffer, offset, level, 0, level.length);
            ArrayList<DiskAddress> mazeBlocks = new ArrayList<DiskAddress>();
            int ptr = mazeData.dataOffset + i * 2;
            mazeBlocks.add((DiskAddress)blocks.get(ptr));
            mazeBlocks.add((DiskAddress)blocks.get(ptr + 1));
            this.addToNode(new MazeLevel(level, i), mazeNode, mazeBlocks);
            ++i;
        }
    }

    private void linkMazeLevels5(DefaultMutableTreeNode scenarioNode, FileEntry fileEntry) {
        byte[] buffer = fileEntry.getDataSource().buffer;
        List blocks = fileEntry.getSectors();
        DefaultMutableTreeNode mazeNode = this.linkNode("Maze", "Level 5 mazes", scenarioNode);
        ArrayList<DiskAddress> allMazeBlocks = new ArrayList<DiskAddress>();
        int dataSize = 922;
        int base = 6144;
        int i = 0;
        while (i < 8) {
            int offset = base + i * 1024;
            byte[] data = new byte[2048];
            System.arraycopy(buffer, offset, data, 0, dataSize);
            System.arraycopy(buffer, offset + 8192, data, 1024, dataSize);
            MazeGridV5 grid = new MazeGridV5("Maze level " + (i + 1), data, this.messageBlock);
            ArrayList<DiskAddress> mazeBlocks = new ArrayList<DiskAddress>();
            int j = 0;
            while (j < 4) {
                mazeBlocks.add((DiskAddress)blocks.get(12 + i * 4 + j));
                ++j;
            }
            allMazeBlocks.addAll(mazeBlocks);
            this.addToNode(grid, mazeNode, mazeBlocks);
            ++i;
        }
        DefaultAppleFileSource afs = (DefaultAppleFileSource)mazeNode.getUserObject();
        afs.setSectors(allMazeBlocks);
    }

    private void linkBlock1(DefaultMutableTreeNode scenarioNode, FileEntry fileEntry) {
        byte[] buffer = fileEntry.getDataSource().buffer;
        List blocks = fileEntry.getSectors();
        StringBuilder text = new StringBuilder();
        ArrayList<DiskAddress> allBlocks = new ArrayList<DiskAddress>();
        int i = 0;
        while (i < 23) {
            allBlocks.add((DiskAddress)blocks.get(44 + i));
            ++i;
        }
        int offset = 22528;
        int length = 66;
        int i2 = 0;
        while (i2 < 179) {
            text.append(String.format("%04X : %s%n", offset + i2 * length, HexFormatter.getHexString(buffer, offset + i2 * length, length)));
            ++i2;
        }
        DefaultMutableTreeNode oracleNode = this.linkNode("Block1", text.toString(), scenarioNode);
        oracleNode.setAllowsChildren(false);
        DefaultAppleFileSource afs = (DefaultAppleFileSource)oracleNode.getUserObject();
        afs.setSectors(allBlocks);
    }

    private void linkBlock2(DefaultMutableTreeNode scenarioNode, FileEntry fileEntry) {
        byte[] buffer = fileEntry.getDataSource().buffer;
        List blocks = fileEntry.getSectors();
        StringBuilder text = new StringBuilder();
        ArrayList<DiskAddress> allBlocks = new ArrayList<DiskAddress>();
        int i = 0;
        while (i < 19) {
            allBlocks.add((DiskAddress)blocks.get(87 + i));
            ++i;
        }
        int offset = 44544;
        int length = 60;
        int i2 = 0;
        while (i2 < 150) {
            text.append(String.format("%04X : %s%n", offset + i2 * length, HexFormatter.getHexString(buffer, offset + i2 * length, length)));
            ++i2;
        }
        DefaultMutableTreeNode oracleNode = this.linkNode("Block2", text.toString(), scenarioNode);
        oracleNode.setAllowsChildren(false);
        DefaultAppleFileSource afs = (DefaultAppleFileSource)oracleNode.getUserObject();
        afs.setSectors(allBlocks);
    }

    private void linkOracle(DefaultMutableTreeNode scenarioNode, FileEntry fileEntry) {
        byte[] buffer = fileEntry.getDataSource().buffer;
        List blocks = fileEntry.getSectors();
        StringBuilder text = new StringBuilder();
        int i = 0;
        while (i < 320) {
            int offset = 34304 + i * 32 + 18;
            int key = Utility.getShort(buffer, offset);
            if (key > 0) {
                text.append(String.format("%04X  %04X  * %s%n", offset, key, this.messageBlock.getMessageText(key)));
            }
            if ((key = Utility.getShort(buffer, offset + 8)) > 0) {
                text.append(String.format("%04X  %04X    %s%n", offset + 8, key, this.messageBlock.getMessageText(key)));
            }
            ++i;
        }
        ArrayList<DiskAddress> allOracleBlocks = new ArrayList<DiskAddress>();
        int i2 = 0;
        while (i2 < 20) {
            allOracleBlocks.add((DiskAddress)blocks.get(67 + i2));
            ++i2;
        }
        DefaultMutableTreeNode oracleNode = this.linkNode("Oracle", text.toString(), scenarioNode);
        oracleNode.setAllowsChildren(false);
        DefaultAppleFileSource afs = (DefaultAppleFileSource)oracleNode.getUserObject();
        afs.setSectors(allOracleBlocks);
    }

    private void addToNode(AbstractFile af, DefaultMutableTreeNode node, List<DiskAddress> blocks) {
        DefaultAppleFileSource dafs = new DefaultAppleFileSource(af.getName(), af, this, blocks);
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(dafs);
        childNode.setAllowsChildren(false);
        node.add(childNode);
    }

    private DefaultMutableTreeNode linkNode(String name, String text, DefaultMutableTreeNode parent) {
        DefaultAppleFileSource afs = new DefaultAppleFileSource(name, text, (FormattedDisk)this);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(afs);
        parent.add(node);
        return node;
    }

    public static boolean isWizardryIVorV(Disk disk, boolean debug) {
        byte[] byArray = new byte[7];
        byArray[1] = -22;
        byArray[2] = -87;
        byArray[3] = 96;
        byArray[4] = -115;
        byArray[5] = 1;
        byArray[6] = 8;
        byte[] header = byArray;
        byte[] buffer = disk.readBlock(0);
        if (!Utility.matches(buffer, 0, header)) {
            return false;
        }
        buffer = disk.readBlock(1);
        return buffer[510] == 1 && buffer[511] == 0;
    }
}

