/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.wizardry;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.wizardry.Wiz4Image;
import java.util.ArrayList;
import java.util.List;

public class Wiz4Monsters
extends AbstractFile {
    final List<Wiz4Image> images = new ArrayList<Wiz4Image>();
    final List<Integer> blocks = new ArrayList<Integer>();

    public Wiz4Monsters(String name, byte[] buffer) {
        super(name, buffer);
        int count = 0;
        int block = 0;
        while (block < 24) {
            int ptr = block * 512;
            int pic = 0;
            while (pic < 2) {
                byte[] data = new byte[240];
                System.arraycopy(buffer, ptr + pic * 256, data, 0, data.length);
                Wiz4Image image = new Wiz4Image("Image " + count++, data, 5, 6);
                this.images.add(image);
                this.blocks.add(block);
                ++pic;
            }
            ++block;
        }
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        int count = 1;
        int block = 0;
        while (block < 24) {
            int ptr = block * 512;
            int pic = 0;
            while (pic < 2) {
                text.append(String.format("%3d : %s%n", count, HexFormatter.getHexString(this.buffer, ptr + pic * 256, 240)));
                ++count;
                ++pic;
            }
            ++block;
        }
        return text.toString();
    }
}

