/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.wizardry;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;
import com.bytezone.diskbrowser.wizardry.Dice;

class Item
extends AbstractFile
implements Comparable<Item> {
    public final int itemID = counter++;
    private final int type;
    private final long cost;
    public int partyOwns;
    String genericName;
    static int counter = 0;
    public final Dice damage;
    public final int armourClass;
    public final int speed;

    Item(String name, byte[] buffer) {
        super(name, buffer);
        this.type = buffer[32];
        this.cost = (long)(Utility.getShort(buffer, 44) + Utility.getShort(buffer, 46) * 10000) + (long)Utility.getShort(buffer, 48) * 100000000L;
        this.genericName = HexFormatter.getPascalString(buffer, 16);
        this.damage = new Dice(buffer, 66);
        this.armourClass = buffer[62];
        this.speed = buffer[72];
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        text.append("Name ......... : " + this.getName());
        text.append("\nGeneric name . : " + this.genericName);
        text.append("\nType ......... : " + this.type);
        text.append("\nCost ......... : " + this.cost);
        text.append("\nArmour class . : " + this.armourClass);
        text.append("\nDamage ....... : " + this.damage);
        text.append("\nSpeed ........ : " + this.speed);
        text.append("\nCursed? ...... : " + this.isCursed());
        int stock = this.getStockOnHand();
        text.append("\nStock on hand  : " + stock);
        if (stock < 0) {
            text.append(" (always in stock)");
        }
        return text.toString();
    }

    public int getType() {
        return this.type;
    }

    public long getCost() {
        return this.cost;
    }

    public boolean isCursed() {
        return this.buffer[36] != 0;
    }

    public int getStockOnHand() {
        if (this.buffer[50] == -1 && this.buffer[51] == -1) {
            return -1;
        }
        return Utility.getShort(this.buffer, 50);
    }

    public boolean canUse(int type2) {
        int users = this.buffer[54] & 0xFF;
        return (users >>> type2 & 1) == 1;
    }

    public String toString() {
        StringBuilder line = new StringBuilder();
        line.append(String.format("%-16s", this.getName()));
        if (this.buffer[36] == -1) {
            line.append("(c) ");
        } else {
            line.append("    ");
        }
        line.append(String.format("%02X ", this.buffer[62]));
        line.append(String.format("%02X ", this.buffer[34]));
        line.append(String.format("%02X %02X", this.buffer[50], this.buffer[51]));
        int i = 38;
        while (i < 44) {
            line.append(String.valueOf(HexFormatter.format2(this.buffer[i])) + " ");
            ++i;
        }
        i = 48;
        while (i < 50) {
            line.append(String.valueOf(HexFormatter.format2(this.buffer[i])) + " ");
            ++i;
        }
        i = 52;
        while (i < 62) {
            line.append(String.valueOf(HexFormatter.format2(this.buffer[i])) + " ");
            ++i;
        }
        return line.toString();
    }

    public String getDump(int block) {
        StringBuilder line = new StringBuilder(String.format("%3d %-16s", this.itemID, this.getName()));
        int lo = block == 0 ? 32 : (block == 1 ? 46 : 70);
        int hi = lo + 24;
        if (hi > this.buffer.length) {
            hi = this.buffer.length;
        }
        int i = lo;
        while (i < hi) {
            line.append(String.format("%02X ", this.buffer[i]));
            ++i;
        }
        return line.toString();
    }

    @Override
    public int compareTo(Item otherItem) {
        Item item = otherItem;
        return this.type - item.type;
    }
}

