/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.wizardry;

import com.bytezone.diskbrowser.applefile.AbstractFile;

class Huffman
extends AbstractFile {
    private static final byte[] mask = new byte[]{2, 1};
    private static final int[] offset = new int[]{512, 256};
    private byte depth;
    private int msgPtr;
    private byte currentByte;
    private byte[] message;
    private String bufferContents;

    Huffman(String name, byte[] buffer) {
        super(name, buffer);
    }

    String decodeMessage(byte[] message) {
        this.message = message;
        this.depth = 0;
        this.msgPtr = 0;
        this.currentByte = 0;
        int len = this.getChar();
        StringBuilder text = new StringBuilder();
        int i = 0;
        while (i < len) {
            text.append((char)this.getChar());
            ++i;
        }
        return text.toString();
    }

    private byte getChar() {
        int treePtr = 0;
        while (true) {
            byte by = this.depth;
            this.depth = (byte)(by + 1);
            if ((by & 7) == 0) {
                this.currentByte = this.message[this.msgPtr++];
            }
            int currentBit = this.currentByte & 1;
            this.currentByte = (byte)(this.currentByte >> 1);
            byte nodeValue = this.buffer[treePtr + offset[currentBit]];
            if ((this.buffer[treePtr] & mask[currentBit]) != 0) {
                return nodeValue;
            }
            treePtr = nodeValue & 0xFF;
        }
    }

    @Override
    public String getText() {
        if (this.bufferContents == null) {
            StringBuilder text = new StringBuilder();
            this.walk(0, "", text);
            this.bufferContents = text.toString();
        }
        return this.bufferContents;
    }

    private void walk(int treePtr, String path, StringBuilder text) {
        int currentBit = 1;
        while (currentBit >= 0) {
            if ((this.buffer[treePtr] & mask[currentBit]) == 0) {
                this.walk(this.buffer[treePtr + offset[currentBit]] & 0xFF, String.valueOf(path) + currentBit, text);
            } else {
                int val = this.buffer[treePtr + offset[currentBit]] & 0xFF;
                char c = val < 32 || val >= 127 ? (char)' ' : (char)val;
                text.append(String.format("%3d  %1.1s  %s%n", val, Character.valueOf(c), String.valueOf(path) + currentBit));
            }
            --currentBit;
        }
    }
}

