/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.visicalc;

import com.bytezone.diskbrowser.visicalc.Address;
import com.bytezone.diskbrowser.visicalc.Cell;
import com.bytezone.diskbrowser.visicalc.Expression;
import com.bytezone.diskbrowser.visicalc.Range;
import com.bytezone.diskbrowser.visicalc.Value;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class ValueList
implements Iterable<Value> {
    private final List<Value> values = new ArrayList<Value>();
    private boolean hasRange;

    ValueList(Cell cell, String text) {
        String remainder = text;
        while (true) {
            String parameter;
            if (Range.isRange(parameter = Expression.getParameter(remainder))) {
                this.hasRange = true;
                for (Address address : new Range(cell, parameter)) {
                    this.values.add(cell.getCell(address));
                }
            } else {
                this.values.add(new Expression(cell, parameter).reduce());
            }
            if (remainder.length() == parameter.length()) break;
            remainder = remainder.substring(parameter.length() + 1);
        }
    }

    public boolean hasRange() {
        return this.hasRange;
    }

    public Value get(int index) {
        return this.values.get(index);
    }

    public int size() {
        return this.values.size();
    }

    @Override
    public Iterator<Value> iterator() {
        return this.values.iterator();
    }
}

