/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.visicalc;

import com.bytezone.diskbrowser.visicalc.AbstractValue;
import com.bytezone.diskbrowser.visicalc.Cell;
import com.bytezone.diskbrowser.visicalc.Value;

class Number
extends AbstractValue {
    Number(Cell cell, String text) {
        super(cell, text);
        try {
            this.valueType = Value.ValueType.NUMBER;
            this.valueResult = Value.ValueResult.VALID;
            this.value = Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            this.valueResult = Value.ValueResult.ERROR;
            e.printStackTrace();
        }
    }

    @Override
    public String getType() {
        return "Constant";
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(String.format("%s%n", "+-----------------------------------------------------------------------------------+"));
        this.attach(text, this.getType(), this.getFullText(), this);
        return text.toString();
    }
}

