/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.visicalc;

import com.bytezone.diskbrowser.visicalc.Cell;
import com.bytezone.diskbrowser.visicalc.Value;
import com.bytezone.diskbrowser.visicalc.ValueListFunction;

class Min
extends ValueListFunction {
    Min(Cell cell, String text) {
        super(cell, text);
        assert (text.startsWith("@MIN(")) : text;
    }

    @Override
    public void calculate() {
        this.value = Double.MAX_VALUE;
        int totalChecked = 0;
        this.valueResult = Value.ValueResult.VALID;
        for (Value v : this.list) {
            v.calculate();
            if (!v.isValid()) {
                this.valueResult = this.cell.getValueResult();
                return;
            }
            this.value = Math.min(this.value, v.getDouble());
            ++totalChecked;
        }
        if (totalChecked == 0) {
            this.valueResult = Value.ValueResult.NA;
        }
    }
}

