/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.visicalc;

import com.bytezone.diskbrowser.visicalc.Address;
import com.bytezone.diskbrowser.visicalc.Cell;
import com.bytezone.diskbrowser.visicalc.Value;
import com.bytezone.diskbrowser.visicalc.ValueListFunction;

class Lookup
extends ValueListFunction {
    Lookup(Cell cell, String text) {
        super(cell, text);
        assert (text.startsWith("@LOOKUP(")) : text;
    }

    @Override
    public void calculate() {
        Value source = this.list.get(0);
        this.valueResult = Value.ValueResult.VALID;
        source.calculate();
        if (!source.isValid()) {
            this.valueResult = source.getValueResult();
            return;
        }
        if (this.list.size() <= 1) {
            this.valueResult = Value.ValueResult.NA;
            return;
        }
        double sourceValue = source.getDouble();
        Address target = null;
        int i = 1;
        while (i < this.list.size()) {
            Cell cell = (Cell)this.list.get(i);
            if (cell.getDouble() > sourceValue) break;
            target = cell.getAddress();
            ++i;
        }
        if (target == null) {
            this.valueResult = Value.ValueResult.NA;
            return;
        }
        Address adjacentAddress = this.isVertical() ? target.nextColumn() : target.nextRow();
        this.value = this.cell.cellExists(adjacentAddress) ? this.cell.getCell(adjacentAddress).getDouble() : 0.0;
    }

    private boolean isVertical() {
        Cell firstCell = (Cell)this.list.get(1);
        Cell lastCell = (Cell)this.list.get(this.list.size() - 1);
        return firstCell.getAddress().columnMatches(lastCell.getAddress());
    }
}

