/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.visicalc;

import com.bytezone.diskbrowser.visicalc.Cell;
import com.bytezone.diskbrowser.visicalc.Condition;
import com.bytezone.diskbrowser.visicalc.Expression;
import com.bytezone.diskbrowser.visicalc.Function;
import com.bytezone.diskbrowser.visicalc.Value;

class If
extends Function {
    private final String conditionText;
    private final String textTrue;
    private final String textFalse;
    private final Condition condition;
    private final Value expTrue;
    private final Value expFalse;

    If(Cell cell, String text) {
        super(cell, text);
        assert (text.startsWith("@IF(")) : text;
        this.conditionText = Expression.getParameter(this.functionText);
        int ptr = this.conditionText.length() + 1;
        if (ptr >= this.functionText.length()) {
            throw new IllegalArgumentException(text);
        }
        this.textTrue = Expression.getParameter(this.functionText.substring(ptr));
        ptr = this.conditionText.length() + this.textTrue.length() + 2;
        if (ptr >= this.functionText.length()) {
            throw new IllegalArgumentException(text);
        }
        this.textFalse = Expression.getParameter(this.functionText.substring(ptr));
        this.condition = new Condition(cell, this.conditionText);
        this.values.add(this.condition);
        this.expTrue = new Expression(cell, this.textTrue).reduce();
        this.values.add(this.expTrue);
        this.expFalse = new Expression(cell, this.textFalse).reduce();
        this.values.add(this.expFalse);
        this.valueType = this.expTrue.getValueType();
    }

    @Override
    public void calculate() {
        this.valueResult = Value.ValueResult.VALID;
        this.condition.calculate();
        if (this.condition.getBoolean()) {
            this.expTrue.calculate();
            if (!this.expTrue.isValid()) {
                this.valueResult = this.expTrue.getValueResult();
            } else if (this.valueType == Value.ValueType.NUMBER) {
                this.value = this.expTrue.getDouble();
            } else {
                this.bool = this.expTrue.getBoolean();
            }
        } else {
            this.expFalse.calculate();
            if (!this.expFalse.isValid()) {
                this.valueResult = this.expTrue.getValueResult();
            } else if (this.valueType == Value.ValueType.NUMBER) {
                this.value = this.expFalse.getDouble();
            } else {
                this.bool = this.expFalse.getBoolean();
            }
        }
    }

    @Override
    public String getType() {
        return "If";
    }

    @Override
    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(String.format("%s%n", "+-----------------------------------------------------------------------------------+"));
        text.append(String.format("| %-9.9s : %-50.50s %-8.8s %-10.10s|%n", new Object[]{this.getType(), this.getFullText(), this.getValueType(), this.getValueText(this)}));
        this.attach(text, "condition", this.conditionText, this.condition);
        if (this.condition.getBoolean()) {
            this.attach(text, "true", this.textTrue, this.expTrue);
        } else {
            this.attach(text, "false", this.textFalse, this.expFalse);
        }
        return text.toString();
    }
}

