/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.visicalc;

import com.bytezone.diskbrowser.visicalc.AbstractValue;
import com.bytezone.diskbrowser.visicalc.Cell;
import com.bytezone.diskbrowser.visicalc.Value;

abstract class Function
extends AbstractValue {
    static final String[] functionList = new String[]{"@ABS(", "@ACOS(", "@AND(", "@ASIN(", "@ATAN(", "@AVERAGE(", "@COUNT(", "@CHOOSE(", "@COS(", "@ERROR", "@EXP(", "@FALSE", "@IF(", "@INT(", "@ISERROR(", "@ISNA(", "@LOG10(", "@LOOKUP(", "@LN(", "@MIN(", "@MAX(", "@NA", "@NOT(", "@NPV(", "@OR(", "@PI", "@SIN(", "@SUM(", "@SQRT(", "@TAN(", "@TRUE"};
    protected final String functionName;
    protected final String functionText;

    Function(Cell cell, String text) {
        super(cell, text);
        int pos = text.indexOf(40);
        if (pos >= 0) {
            this.functionName = text.substring(0, pos);
            this.functionText = text.substring(pos + 1, text.length() - 1);
        } else {
            this.functionName = text;
            this.functionText = "";
        }
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(String.format("%s%n", "+-----------------------------------------------------------------------------------+"));
        text.append(String.format("| %-9.9s : %-50.50s %-8.8s %-10.10s|%n", new Object[]{"Function", this.getFullText(), this.valueType, this.getValueText(this)}));
        for (Value value : this.values) {
            text.append(String.format("| %-9.9s : %-50.50s %-8.8s %-10.10s|%n", new Object[]{value.getType(), value.getFullText(), value.getValueType(), this.getValueText(value)}));
        }
        return text.toString();
    }
}

