/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.visicalc;

import com.bytezone.diskbrowser.visicalc.AbstractValue;
import com.bytezone.diskbrowser.visicalc.Cell;
import com.bytezone.diskbrowser.visicalc.Condition;
import com.bytezone.diskbrowser.visicalc.Function;
import com.bytezone.diskbrowser.visicalc.Number;
import com.bytezone.diskbrowser.visicalc.Value;
import java.util.ArrayList;
import java.util.List;

class Expression
extends AbstractValue {
    private final List<String> operators = new ArrayList<String>();
    private final List<String> signs = new ArrayList<String>();

    Expression(Cell cell, String text) {
        super(cell, text);
        String line = this.balanceBrackets(text);
        if (Condition.isCondition(text)) {
            this.values.add(new Condition(cell, text));
            this.signs.add("(+)");
            return;
        }
        int ptr = 0;
        while (ptr < line.length()) {
            char ch = line.charAt(ptr);
            if (ch == '-') {
                this.signs.add("(-)");
                ch = line.charAt(++ptr);
            } else {
                this.signs.add("(+)");
                if (ch == '+') {
                    ch = line.charAt(++ptr);
                }
            }
            switch (ch) {
                case '@': {
                    String functionText = this.getFunctionCall(line.substring(ptr));
                    ptr += functionText.length();
                    this.values.add(cell.getFunction(functionText));
                    break;
                }
                case '(': {
                    String bracketText = this.getBalancedText(line.substring(ptr));
                    ptr += bracketText.length();
                    this.values.add(new Expression(cell, bracketText.substring(1, bracketText.length() - 1)));
                    break;
                }
                case '#': {
                    System.out.printf("Hash character [%s] in [%s]%n", Character.valueOf(ch), line);
                    ++ptr;
                    break;
                }
                default: {
                    if (ch == '.' || ch >= '0' && ch <= '9') {
                        String numberText = this.getNumberText(line.substring(ptr));
                        ptr += numberText.length();
                        this.values.add(new Number(cell, numberText));
                        break;
                    }
                    if (ch >= 'A' && ch <= 'Z') {
                        String addressText = this.getAddressText(line.substring(ptr));
                        ptr += addressText.length();
                        this.values.add(cell.getCell(addressText));
                        break;
                    }
                    System.out.printf("Unexpected character [%s] in [%s]%n", Character.valueOf(ch), line);
                    return;
                }
            }
            if (ptr >= line.length()) continue;
            ch = line.charAt(ptr);
            if (ch == '+' || ch == '-' || ch == '*' || ch == '/' || ch == '^') {
                this.operators.add(line.substring(ptr++, ptr));
                continue;
            }
            System.out.printf("Unknown operator [%s] in [%s]%n", Character.valueOf(ch), line);
            return;
        }
        assert (this.values.size() > 0);
        this.valueType = ((Value)this.values.get(0)).getValueType();
    }

    Value reduce() {
        return this.values.size() == 1 && this.signs.get(0).equals("(+)") ? (Value)this.values.get(0) : this;
    }

    Value get(int index) {
        if (index < 0 || index >= this.values.size()) {
            throw new IllegalArgumentException();
        }
        return (Value)this.values.get(index);
    }

    @Override
    public String getType() {
        return "Expression";
    }

    @Override
    public void calculate() {
        assert (this.values.size() > 0);
        try {
            Value thisValue = (Value)this.values.get(0);
            thisValue.calculate();
            if (this.valueType == Value.ValueType.NUMBER) {
                this.value = thisValue.getDouble();
            } else {
                this.bool = thisValue.getBoolean();
            }
            if (!thisValue.isValid()) {
                this.valueType = thisValue.getValueType();
                return;
            }
            String sign = this.signs.get(0);
            if (sign.equals("(-)")) {
                this.value *= -1.0;
            }
            int i = 1;
            while (i < this.values.size()) {
                String operator;
                thisValue = (Value)this.values.get(i);
                thisValue.calculate();
                if (!thisValue.isValid()) {
                    this.valueType = thisValue.getValueType();
                    return;
                }
                double nextValue = thisValue.getDouble();
                sign = this.signs.get(i);
                if (sign.equals("(-)")) {
                    nextValue *= -1.0;
                }
                if ((operator = this.operators.get(i - 1)).equals("+")) {
                    this.value += nextValue;
                } else if (operator.equals("-")) {
                    this.value -= nextValue;
                } else if (operator.equals("*")) {
                    this.value *= nextValue;
                } else if (operator.equals("/")) {
                    if (nextValue == 0.0) {
                        this.valueResult = Value.ValueResult.ERROR;
                        return;
                    }
                    this.value /= nextValue;
                } else if (operator.equals("^")) {
                    this.value = Math.pow(this.value, nextValue);
                }
                if (Double.isNaN(this.value)) {
                    this.valueResult = Value.ValueResult.ERROR;
                    return;
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.valueResult = Value.ValueResult.ERROR;
            e.printStackTrace();
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private String balanceBrackets(String input) {
        block5: {
            line = input.trim();
            leftBracket = 0;
            rightBracket = 0;
            var8_5 = line.toCharArray();
            var7_6 = var8_5.length;
            var6_7 = 0;
            while (var6_7 < var7_6) {
                c = var8_5[var6_7];
                if (c == '(') {
                    ++leftBracket;
                } else if (c == ')') {
                    ++rightBracket;
                }
                ++var6_7;
            }
            if (leftBracket == rightBracket) break block5;
            if (rightBracket <= leftBracket) ** GOTO lbl24
            System.out.printf("**** Unbalanced brackets: left:%d, right:%d  ****%n", new Object[]{leftBracket, rightBracket});
            System.out.println(input);
            return "@ERROR";
lbl-1000:
            // 1 sources

            {
                line = String.valueOf(line) + ")";
                ++rightBracket;
lbl24:
                // 2 sources

                ** while (rightBracket < leftBracket)
            }
        }
        return line;
    }

    private String getBalancedText(String text) {
        int ptr = text.indexOf(40);
        if (ptr < 0) {
            return text;
        }
        int depth = 1;
        while (++ptr < text.length()) {
            if (text.charAt(ptr) == ')') {
                if (--depth != 0) continue;
                break;
            }
            if (text.charAt(ptr) != '(') continue;
            ++depth;
        }
        return text.substring(0, ptr + 1);
    }

    static String getParameter(String text) {
        int depth = 0;
        int ptr = 0;
        while (ptr < text.length()) {
            char c = text.charAt(ptr);
            if (c == '(') {
                ++depth;
            } else if (c == ')') {
                --depth;
            } else if (c == ',' && depth == 0) break;
            ++ptr;
        }
        return text.substring(0, ptr);
    }

    private String getFunctionCall(String text) {
        if (text.charAt(0) != '@') {
            throw new IllegalArgumentException("Bad function name: " + text);
        }
        String[] stringArray = Function.functionList;
        int n = Function.functionList.length;
        int n2 = 0;
        while (n2 < n) {
            String functionName = stringArray[n2];
            if (text.startsWith(functionName)) {
                if (functionName.endsWith("(")) {
                    return this.getBalancedText(text);
                }
                return functionName;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Bad function name: " + text);
    }

    private String getNumberText(String text) {
        int ptr = 0;
        while (++ptr < text.length()) {
            char c = text.charAt(ptr);
            if (c != '.' && (c < '0' || c > '9')) break;
        }
        return text.substring(0, ptr);
    }

    private String getAddressText(String text) {
        int ptr = 0;
        while (++ptr < text.length()) {
            char c = text.charAt(ptr);
            if ((c < '0' || c > '9') && (c < 'A' || c > 'Z')) break;
        }
        return text.substring(0, ptr);
    }

    public String fullText() {
        StringBuilder text = new StringBuilder();
        int ptr = 0;
        for (Value value : this.values) {
            assert (value != null);
            text.append(this.signs.get(ptr));
            text.append(value.getDouble());
            if (ptr >= this.operators.size()) continue;
            text.append(this.operators.get(ptr++));
        }
        return text.toString();
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(String.format("%s%n", "+-----------------------------------------------------------------------------------+"));
        text.append(String.format("| %-9.9s : %-50.50s %-8.8s %-10.10s|%n", new Object[]{"Exprssion", this.getFullText(), this.valueType, this.getValueText(this)}));
        int index = 0;
        for (Value value : this.values) {
            String sign = this.signs.get(index);
            if (!"(+)".equals(sign)) {
                text.append(String.format("| %-9.9s : %-70.70s|%n", "sign", sign));
            }
            text.append(String.format("| %-9.9s : %-50.50s %-8.8s %-10.10s|%n", new Object[]{value.getType(), value.getFullText(), value.getValueType(), this.getValueText(value)}));
            if (index < this.operators.size()) {
                text.append(String.format("| %-9.9s : %-70.70s|%n", "operator", this.operators.get(index)));
            }
            ++index;
        }
        return text.toString();
    }
}

