/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.visicalc;

import com.bytezone.diskbrowser.visicalc.Address;
import com.bytezone.diskbrowser.visicalc.Cell;
import com.bytezone.diskbrowser.visicalc.Condition;
import com.bytezone.diskbrowser.visicalc.Expression;
import com.bytezone.diskbrowser.visicalc.Range;
import com.bytezone.diskbrowser.visicalc.Value;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class ConditionList
implements Iterable<Value> {
    private final List<Value> conditions = new ArrayList<Value>();

    ConditionList(Cell cell, String text) {
        String remainder = text;
        while (true) {
            String parameter;
            if (Range.isRange(parameter = Expression.getParameter(remainder))) {
                for (Address address : new Range(cell, parameter)) {
                    Cell target = cell.getCell(address);
                    this.conditions.add(target);
                }
            } else {
                this.conditions.add(new Condition(cell, parameter));
            }
            if (remainder.length() == parameter.length()) break;
            remainder = remainder.substring(parameter.length() + 1);
        }
    }

    public Value get(int index) {
        return this.conditions.get(index);
    }

    public int size() {
        return this.conditions.size();
    }

    @Override
    public Iterator<Value> iterator() {
        return this.conditions.iterator();
    }
}

