/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.visicalc;

import com.bytezone.diskbrowser.visicalc.Address;
import com.bytezone.diskbrowser.visicalc.Error;
import com.bytezone.diskbrowser.visicalc.Expression;
import com.bytezone.diskbrowser.visicalc.Format;
import com.bytezone.diskbrowser.visicalc.Function;
import com.bytezone.diskbrowser.visicalc.Sheet;
import com.bytezone.diskbrowser.visicalc.Value;
import java.util.Iterator;

class Cell
implements Value,
Comparable<Cell> {
    private static final String empty = "                                        ";
    private final Address address;
    private final Sheet parent;
    private String fullText;
    private char cellFormat = (char)32;
    private String repeat = "";
    private boolean calculated;
    private CellType cellType;
    private String repeatingText;
    private String label;
    private Value value;

    Cell(Sheet parent, Address address) {
        this.parent = parent;
        this.address = address;
        this.cellType = CellType.EMPTY;
    }

    void setFormat(String formatText) {
        if (formatText.startsWith("/T")) {
            return;
        }
        if (formatText.startsWith("/F")) {
            this.cellFormat = formatText.charAt(2);
            return;
        }
        if (formatText.startsWith("/-")) {
            assert (this.cellType == CellType.EMPTY);
            this.repeatingText = formatText.substring(2);
            int i = 0;
            while (i < 20) {
                this.repeat = String.valueOf(this.repeat) + this.repeatingText;
                ++i;
            }
            this.cellType = CellType.FILLER;
            return;
        }
        System.out.printf("Unexpected format [%s]%n", formatText);
    }

    void setValue(String valueText) {
        assert (this.cellType == CellType.EMPTY);
        if (!valueText.isEmpty() && valueText.charAt(0) == '\"') {
            this.label = valueText.substring(1);
            this.cellType = CellType.LABEL;
        } else {
            this.fullText = valueText;
            this.cellType = CellType.VALUE;
            try {
                this.value = new Expression(this, this.fullText).reduce();
            }
            catch (IllegalArgumentException e) {
                this.value = new Error(this, "@ERROR");
            }
        }
    }

    void reset() {
        this.calculated = false;
    }

    Value getExpressionValue(String text) {
        return new Expression(this, text).reduce();
    }

    boolean isCellType(CellType cellType) {
        return this.cellType == cellType;
    }

    Address getAddress() {
        return this.address;
    }

    String getFormattedText(int colWidth, char globalFormat) {
        char fmtChar = this.cellFormat != ' ' ? this.cellFormat : globalFormat;
        switch (this.cellType) {
            case LABEL: {
                if (fmtChar != 'R') {
                    fmtChar = 'L';
                }
                return Format.justify(this.label, colWidth, fmtChar);
            }
            case FILLER: {
                return Format.justify(this.repeat, colWidth, ' ');
            }
            case EMPTY: {
                return Format.justify(empty, colWidth, ' ');
            }
            case VALUE: {
                switch (this.getValueResult()) {
                    case ERROR: 
                    case NA: {
                        if (fmtChar == ' ') {
                            fmtChar = 'R';
                        }
                        return " " + Format.justify(this.value.getText(), colWidth - 1, fmtChar);
                    }
                    case VALID: {
                        switch (this.getValueType()) {
                            case BOOLEAN: {
                                if (fmtChar != 'L') {
                                    fmtChar = 'R';
                                }
                                return Format.justify(this.value.getText(), colWidth, fmtChar);
                            }
                            case NUMBER: {
                                if (colWidth == 1) {
                                    return ".";
                                }
                                return " " + Format.format(this.value, fmtChar, colWidth - 1);
                            }
                        }
                        assert (false);
                        return "Impossible";
                    }
                }
                assert (false);
                return "Impossible";
            }
        }
        assert (false);
        return "impossible";
    }

    Cell getCell(Address address) {
        return this.parent.getCell(address);
    }

    Cell getCell(String addressText) {
        return this.parent.getCell(addressText);
    }

    boolean cellExists(Address address) {
        return this.parent.cellExists(address);
    }

    Function getFunction(String text) {
        return this.parent.getFunction(this, text);
    }

    @Override
    public void calculate() {
        if (this.cellType == CellType.VALUE && !this.calculated) {
            this.value.calculate();
            this.calculated = true;
        }
    }

    @Override
    public boolean isValid() {
        return this.cellType == CellType.VALUE ? this.value.isValid() : true;
    }

    @Override
    public Value.ValueType getValueType() {
        return this.cellType == CellType.VALUE ? this.value.getValueType() : Value.ValueType.NUMBER;
    }

    @Override
    public Value.ValueResult getValueResult() {
        return this.cellType == CellType.VALUE ? this.value.getValueResult() : Value.ValueResult.VALID;
    }

    @Override
    public double getDouble() {
        return this.cellType == CellType.VALUE ? this.value.getDouble() : 0.0;
    }

    @Override
    public boolean getBoolean() {
        return this.cellType == CellType.VALUE ? this.value.getBoolean() : false;
    }

    @Override
    public String getText() {
        return this.cellType == CellType.VALUE ? this.value.getText() : "???";
    }

    @Override
    public String getFullText() {
        switch (this.cellType) {
            case LABEL: {
                return "LBL : " + this.label;
            }
            case FILLER: {
                return "RPT : " + this.repeatingText;
            }
            case EMPTY: {
                return "Empty Cell";
            }
            case VALUE: {
                return this.value.getFullText();
            }
        }
        return "impossible";
    }

    @Override
    public String getType() {
        return "Cell " + this.address.getText();
    }

    @Override
    public int size() {
        return this.cellType == CellType.VALUE ? this.value.size() : 0;
    }

    @Override
    public Iterator<Value> iterator() {
        return this.cellType == CellType.VALUE ? this.value.iterator() : null;
    }

    private void setTestData(int choice) {
        if (choice == 1) {
            System.out.println("****** Hardcoded values ******");
            if (this.address.getRowKey() == 67) {
                this.fullText = "1000";
            } else if (this.address.getRowKey() == 131) {
                this.fullText = "10.5";
            } else if (this.address.getRowKey() == 195) {
                this.fullText = "12";
            } else if (this.address.getRowKey() == 259) {
                this.fullText = "8";
            }
        }
        if (choice == 2) {
            System.out.println("****** Hardcoded values ******");
            if (this.address.getRowKey() == 66) {
                this.fullText = "10";
            } else if (this.address.getRowKey() == 130) {
                this.fullText = "30";
            } else if (this.address.getRowKey() == 194) {
                this.fullText = "65";
            } else if (this.address.getRowKey() == 258) {
                this.fullText = "1000";
            } else if (this.address.getRowKey() == 386) {
                this.fullText = "15";
            }
        }
        if (choice == 3) {
            System.out.println("****** Hardcoded values ******");
            if (this.address.getRowKey() == 67) {
                this.fullText = "9375";
            } else if (this.address.getRowKey() == 131) {
                this.fullText = "4500";
            } else if (this.address.getRowKey() == 195) {
                this.fullText = "24";
            } else if (this.address.getRowKey() == 259) {
                this.fullText = "11.9";
            }
        }
    }

    @Override
    public int compareTo(Cell o) {
        return this.address.compareTo(o.address);
    }

    public String toString() {
        String contents = "";
        String contents2 = "";
        String valueTypeText = "";
        String valueText = "";
        String line2 = "";
        String rest = "";
        switch (this.cellType) {
            case LABEL: {
                contents = this.label;
                break;
            }
            case FILLER: {
                contents = this.repeatingText;
                break;
            }
            case EMPTY: {
                contents = "";
                break;
            }
            case VALUE: {
                contents = this.fullText;
                valueTypeText = "" + (Object)((Object)this.value.getValueType());
                rest = this.value.toString();
                valueText = this.value.getText();
            }
        }
        if (contents.length() > 39) {
            contents2 = contents.substring(39);
            contents = contents.substring(0, 39);
            line2 = String.format("|             %-70.70s|%n", contents2);
        }
        String single = String.format("| %-9.9s : %-39.39s %-10.10s %-8.8s %-10.10s|%n", new Object[]{this.address.getText(), contents, this.cellType, valueTypeText, valueText});
        return String.format("%s%n%s%s%s", "+-----------------------------------------------------------------------------------+", single, line2, rest);
    }

    static enum CellType {
        LABEL,
        FILLER,
        VALUE,
        EMPTY;

    }
}

