/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.visicalc;

import com.bytezone.diskbrowser.visicalc.Cell;
import com.bytezone.diskbrowser.visicalc.Value;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

abstract class AbstractValue
implements Value {
    protected static final String FMT2 = "| %-9.9s : %-70.70s|%n";
    protected static final String FMT4 = "| %-9.9s : %-50.50s %-8.8s %-10.10s|%n";
    protected static final String FMT5 = "| %-9.9s : %-39.39s %-10.10s %-8.8s %-10.10s|%n";
    protected static final String LINE = "+-----------------------------------------------------------------------------------+";
    protected final Cell cell;
    protected final String fullText;
    protected Value.ValueType valueType;
    protected double value;
    protected boolean bool;
    protected Value.ValueResult valueResult = Value.ValueResult.VALID;
    protected List<Value> values = new ArrayList<Value>();

    AbstractValue(Cell cell, String text) {
        this.cell = cell;
        this.fullText = text;
    }

    @Override
    public String getFullText() {
        return this.fullText;
    }

    @Override
    public Value.ValueType getValueType() {
        return this.valueType;
    }

    @Override
    public Value.ValueResult getValueResult() {
        return this.valueResult;
    }

    @Override
    public boolean isValid() {
        return this.valueResult == Value.ValueResult.VALID;
    }

    @Override
    public double getDouble() {
        assert (this.valueType == Value.ValueType.NUMBER);
        return this.value;
    }

    @Override
    public boolean getBoolean() {
        assert (this.valueType == Value.ValueType.BOOLEAN);
        return this.bool;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public String getText() {
        return this.valueResult == Value.ValueResult.VALID ? this.getValueText(this) : "" + (Object)((Object)this.valueResult);
    }

    @Override
    public void calculate() {
    }

    protected void attach(StringBuilder text, String title, String textValue, Value value) {
        text.append(String.format(FMT4, new Object[]{title, textValue, value.getValueType(), this.getValueText(value)}));
        for (Value v : value) {
            text.append(v);
        }
    }

    protected String getValueText(Value value) {
        if (value.getValueType() == Value.ValueType.NUMBER) {
            return String.valueOf(value.getDouble());
        }
        if (value.getValueType() == Value.ValueType.BOOLEAN) {
            return value.getBoolean() ? "TRUE" : "FALSE";
        }
        return "??*??";
    }

    @Override
    public Iterator<Value> iterator() {
        return this.values.iterator();
    }
}

