/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.utilities;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class DateTime {
    private static String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static String[] days = new String[]{"", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static final DateTimeFormatter dtf = DateTimeFormatter.ofPattern("dd-LLL-yy HH:mm");
    private final int second;
    private final int minute;
    private final int hour;
    private final int year;
    private final int day;
    private final int month;
    private final int weekDay;

    public DateTime(byte[] buffer, int ptr) {
        this.second = buffer[ptr] & 0xFF;
        this.minute = buffer[++ptr] & 0xFF;
        this.hour = buffer[++ptr] & 0xFF;
        this.year = buffer[++ptr] & 0xFF;
        this.day = buffer[++ptr] & 0xFF;
        this.month = buffer[++ptr] & 0xFF;
        ++ptr;
        this.weekDay = buffer[++ptr] & 0xFF;
    }

    public String format() {
        return String.format("%02d:%02d:%02d %s %d %s %d", this.hour, this.minute, this.second, days[this.weekDay], this.day, months[this.month], this.year);
    }

    public String format2() {
        LocalDateTime dateTime = this.getLocalDateTime();
        return dateTime == null ? "" : this.getLocalDateTime().format(dtf);
    }

    public LocalDateTime getLocalDateTime() {
        int adjustedYear = this.year + (this.year > 70 ? 1900 : 2000);
        if (this.day < 0 || this.day > 30) {
            return null;
        }
        return LocalDateTime.of(adjustedYear, this.month + 1, this.day + 1, this.hour, this.minute);
    }

    public String toString() {
        return "DateTime [second=" + this.second + ", minute=" + this.minute + ", hour=" + this.hour + ", year=" + this.year + ", day=" + this.day + ", month=" + this.month + ", weekDay=" + this.weekDay + "]";
    }
}

