/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos.write;

import com.bytezone.diskbrowser.prodos.write.IndexBlock;

public class MasterIndexBlock {
    int blockNo;
    IndexBlock[] indexBlocks = new IndexBlock[128];
    int totalBlocks;

    MasterIndexBlock(int blockNo) {
        this.blockNo = blockNo;
    }

    void set(int position, IndexBlock indexBlock) {
        if (this.indexBlocks[position] == null) {
            ++this.totalBlocks;
        }
        this.indexBlocks[position] = indexBlock;
    }

    IndexBlock get(int position) {
        return this.indexBlocks[position];
    }

    void write(byte[] buffer) {
        int ptr = this.blockNo * 512;
        int i = 0;
        while (i < this.indexBlocks.length) {
            IndexBlock indexBlock = this.indexBlocks[i];
            if (indexBlock == null) {
                buffer[ptr + i] = 0;
                buffer[ptr + i + 256] = 0;
            } else {
                indexBlock.write(buffer);
                int blockNo = indexBlock.blockNo;
                buffer[ptr + i] = (byte)(blockNo & 0xFF);
                buffer[ptr + i + 256] = (byte)((blockNo & 0xFF00) >>> 8);
            }
            ++i;
        }
    }
}

