/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos.write;

import com.bytezone.diskbrowser.prodos.write.ProdosDisk;
import com.bytezone.diskbrowser.utilities.Utility;
import java.time.LocalDateTime;

public class FileEntry {
    private final ProdosDisk disk;
    private final byte[] buffer;
    private final int ptr;
    String fileName;
    byte storageType;
    LocalDateTime creationDate;
    LocalDateTime modifiedDate;
    byte fileType;
    int keyPointer;
    int blocksUsed;
    int eof;
    byte version = 0;
    byte minVersion = 0;
    byte access = (byte)-29;
    int auxType;
    int headerPointer;

    public FileEntry(ProdosDisk disk, int ptr) {
        this.disk = disk;
        this.buffer = disk.getBuffer();
        this.ptr = ptr;
    }

    int getBlockNo() {
        return this.ptr / 512;
    }

    int getEntryNo() {
        return (this.ptr % 512 - 4) / 39 + 1;
    }

    void read() {
        this.storageType = (byte)((this.buffer[this.ptr] & 0xF0) >>> 4);
        int nameLength = this.buffer[this.ptr] & 0xF;
        this.fileName = nameLength > 0 ? new String(this.buffer, this.ptr + 1, nameLength) : "";
        this.fileType = this.buffer[this.ptr + 16];
        this.keyPointer = Utility.getShort(this.buffer, this.ptr + 17);
        this.blocksUsed = Utility.getShort(this.buffer, this.ptr + 19);
        this.eof = Utility.readTriple(this.buffer, this.ptr + 21);
        this.creationDate = Utility.getAppleDate(this.buffer, this.ptr + 24);
        this.version = this.buffer[this.ptr + 28];
        this.minVersion = this.buffer[this.ptr + 29];
        this.access = this.buffer[this.ptr + 30];
        this.auxType = Utility.getShort(this.buffer, this.ptr + 31);
        this.modifiedDate = Utility.getAppleDate(this.buffer, this.ptr + 33);
        this.headerPointer = Utility.getShort(this.buffer, this.ptr + 37);
    }

    void write() {
        this.buffer[this.ptr] = (byte)(this.storageType << 4 | this.fileName.length());
        System.arraycopy(this.fileName.getBytes(), 0, this.buffer, this.ptr + 1, this.fileName.length());
        this.buffer[this.ptr + 16] = this.fileType;
        Utility.writeShort(this.buffer, this.ptr + 17, this.keyPointer);
        Utility.writeShort(this.buffer, this.ptr + 19, this.blocksUsed);
        Utility.writeTriple(this.buffer, this.ptr + 21, this.eof);
        Utility.putAppleDate(this.buffer, this.ptr + 24, this.creationDate);
        this.buffer[this.ptr + 28] = this.version;
        this.buffer[this.ptr + 29] = this.minVersion;
        this.buffer[this.ptr + 30] = this.access;
        Utility.writeShort(this.buffer, this.ptr + 31, this.auxType);
        Utility.putAppleDate(this.buffer, this.ptr + 33, this.modifiedDate);
        Utility.writeShort(this.buffer, this.ptr + 37, this.headerPointer);
    }

    String toText() {
        int block = this.ptr / 512;
        int entry = (this.ptr % 512 - 4) / 39 + 1;
        return String.format("%04X:%02X %-15s %02X %04X %02X %04X %04X", block, entry, this.fileName, this.storageType, this.blocksUsed, this.fileType, this.keyPointer, this.headerPointer);
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("------------------------------------------------\n");
        text.append("File Entry\n");
        text.append("------------------------------------------------\n");
        int blockNo = this.ptr / 512;
        text.append(String.format("Block ............ %04X%n", blockNo));
        text.append(String.format("Entry ............ %02X%n", (this.ptr % 512 - 4) / 39 + 1));
        text.append(String.format("Storage type ..... %02X  %s%n", this.storageType, ProdosDisk.storageTypes[this.storageType]));
        text.append(String.format("Name length ...... %02X%n", this.fileName.length()));
        text.append(String.format("File name ........ %s%n", this.fileName));
        text.append(String.format("File type ........ %02X%n", this.fileType));
        text.append(String.format("Key pointer ...... %04X%n", this.keyPointer));
        text.append(String.format("Blocks used ...... %d%n", this.blocksUsed));
        text.append(String.format("EOF .............. %d%n", this.eof));
        text.append(String.format("Created .......... %s%n", this.creationDate));
        text.append(String.format("Version .......... %02X%n", this.version));
        text.append(String.format("Min version ...... %02X%n", this.minVersion));
        text.append(String.format("Access ........... %02X%n", this.access));
        text.append(String.format("Aux .............. %d%n", this.auxType));
        text.append(String.format("Modified ......... %s%n", this.modifiedDate));
        text.append(String.format("Header ptr ....... %04X%n", this.headerPointer));
        text.append("------------------------------------------------\n");
        return text.toString();
    }
}

