/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos.write;

import com.bytezone.diskbrowser.prodos.write.FileEntry;
import com.bytezone.diskbrowser.prodos.write.FileWriter;
import com.bytezone.diskbrowser.prodos.write.ProdosDisk;
import com.bytezone.diskbrowser.utilities.Utility;

public class ExtendedKeyBlock {
    private final ProdosDisk disk;
    private final int ptr;
    private MiniEntry dataFork;
    private MiniEntry resourceFork;

    public ExtendedKeyBlock(ProdosDisk disk, int ptr) {
        this.disk = disk;
        this.ptr = ptr;
    }

    void addMiniEntry(ForkType type, FileEntry fileEntry) {
        this.addMiniEntry(type, fileEntry.storageType, fileEntry.keyPointer, fileEntry.blocksUsed, fileEntry.eof);
    }

    void addMiniEntry(ForkType type, FileWriter fileWriter) {
        this.addMiniEntry(type, fileWriter.storageType, fileWriter.keyPointer, fileWriter.blocksUsed, fileWriter.eof);
    }

    private void addMiniEntry(ForkType type, byte storageType, int keyPointer, int blocksUsed, int eof) {
        if (type == ForkType.DATA) {
            this.dataFork = new MiniEntry(storageType, keyPointer, blocksUsed, eof);
        } else {
            this.resourceFork = new MiniEntry(storageType, keyPointer, blocksUsed, eof);
        }
    }

    void read(byte[] buffer) {
        if (buffer[this.ptr] != 0) {
            this.dataFork = new MiniEntry(buffer, 0);
        }
        if (buffer[this.ptr + 256] != 0) {
            this.resourceFork = new MiniEntry(buffer, 256);
        }
    }

    void write() {
        if (this.dataFork != null) {
            this.dataFork.write(this.disk.getBuffer(), this.ptr);
        }
        if (this.resourceFork != null) {
            this.resourceFork.write(this.disk.getBuffer(), this.ptr + 256);
        }
    }

    static enum ForkType {
        DATA,
        RESOURCE;

    }

    class MiniEntry {
        byte storageType;
        int keyBlock;
        int blocksUsed;
        int eof;

        MiniEntry(byte[] buffer, int ptr) {
            this.read(buffer, ptr);
        }

        MiniEntry(byte storageType, int keyBlock, int blocksUsed, int eof) {
            this.storageType = storageType;
            this.keyBlock = keyBlock;
            this.blocksUsed = blocksUsed;
            this.eof = eof;
        }

        void read(byte[] buffer, int ptr) {
            this.storageType = buffer[ptr];
            this.keyBlock = Utility.getShort(buffer, ptr + 1);
            this.blocksUsed = Utility.getShort(buffer, ptr + 3);
            this.eof = Utility.readTriple(buffer, ptr + 5);
        }

        void write(byte[] buffer, int ptr) {
            buffer[ptr] = this.storageType;
            Utility.writeShort(buffer, ptr + 1, this.keyBlock);
            Utility.writeShort(buffer, ptr + 3, this.blocksUsed);
            Utility.writeTriple(buffer, ptr + 5, this.eof);
        }
    }
}

