/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos.write;

import com.bytezone.diskbrowser.prodos.write.FileEntry;
import com.bytezone.diskbrowser.prodos.write.ProdosDisk;
import com.bytezone.diskbrowser.utilities.Utility;
import java.time.LocalDateTime;

public class DirectoryHeader {
    static final String UNDERLINE = "--------------------------------------------";
    ProdosDisk disk;
    byte[] buffer;
    int ptr;
    String fileName;
    byte storageType;
    LocalDateTime creationDate;
    byte version = 0;
    byte minVersion = 0;
    byte access = (byte)-29;
    byte entryLength = (byte)39;
    byte entriesPerBlock = (byte)13;
    int fileCount;

    public DirectoryHeader(ProdosDisk disk, int ptr) {
        this.disk = disk;
        this.buffer = disk.getBuffer();
        this.ptr = ptr;
    }

    void read() {
        this.storageType = (byte)((this.buffer[this.ptr] & 0xF0) >>> 4);
        int nameLength = this.buffer[this.ptr] & 0xF;
        this.fileName = new String(this.buffer, this.ptr + 1, nameLength);
        this.creationDate = Utility.getAppleDate(this.buffer, this.ptr + 24);
        this.version = this.buffer[this.ptr + 28];
        this.minVersion = this.buffer[this.ptr + 29];
        this.access = this.buffer[this.ptr + 30];
        this.entryLength = this.buffer[this.ptr + 31];
        this.entriesPerBlock = this.buffer[this.ptr + 32];
        this.fileCount = Utility.getShort(this.buffer, this.ptr + 33);
    }

    void write() {
        this.buffer[this.ptr] = (byte)(this.storageType << 4 | this.fileName.length());
        System.arraycopy(this.fileName.getBytes(), 0, this.buffer, this.ptr + 1, this.fileName.length());
        Utility.putAppleDate(this.buffer, this.ptr + 24, this.creationDate);
        this.buffer[this.ptr + 28] = this.version;
        this.buffer[this.ptr + 29] = this.minVersion;
        this.buffer[this.ptr + 30] = this.access;
        this.buffer[this.ptr + 31] = this.entryLength;
        this.buffer[this.ptr + 32] = this.entriesPerBlock;
        Utility.writeShort(this.buffer, this.ptr + 33, this.fileCount);
    }

    void list() {
        int offset;
        System.out.println(UNDERLINE);
        System.out.println(this.toText());
        System.out.println(UNDERLINE);
        int blockNo = this.ptr / 512;
        do {
            offset = blockNo * 512;
            int ptr = offset + 4;
            int i = 0;
            while (i < 13) {
                int storageType = (this.buffer[ptr] & 0xF0) >>> 4;
                int nameLength = this.buffer[ptr] & 0xF;
                if (nameLength != 0 && storageType < 14) {
                    FileEntry fileEntry = new FileEntry(this.disk, ptr);
                    fileEntry.read();
                    System.out.println(fileEntry.toText());
                }
                ptr += 39;
                ++i;
            }
        } while ((blockNo = Utility.getShort(this.buffer, offset + 2)) > 0);
        System.out.println();
    }

    String toText() {
        int block = this.ptr / 512;
        int entry = (this.ptr % 512 - 4) / 39 + 1;
        return String.format("%04X:%02X %-15s %02X %04X", block, entry, this.fileName, this.storageType, this.fileCount);
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        int blockNo = this.ptr / 512;
        text.append(String.format("Block ............ %04X%n", blockNo));
        text.append(String.format("Entry ............ %02X%n", (this.ptr % 512 - 4) / 39 + 1));
        text.append(String.format("Storage type ..... %02X  %s%n", this.storageType, ProdosDisk.storageTypes[this.storageType]));
        text.append(String.format("Name length ...... %02X%n", this.fileName.length()));
        text.append(String.format("File name ........ %s%n", this.fileName));
        text.append(String.format("Version .......... %02X%n", this.version));
        text.append(String.format("Min version ...... %02X%n", this.minVersion));
        text.append(String.format("Created .......... %s%n", this.creationDate));
        text.append(String.format("Access ........... %02X%n", this.access));
        text.append(String.format("Entry length ..... %02X%n", this.entryLength));
        text.append(String.format("Entries per blk .. %02X%n", this.entriesPerBlock));
        text.append(String.format("File count ....... %d%n", this.fileCount));
        return text.toString();
    }
}

