/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos;

import com.bytezone.diskbrowser.disk.AbstractSector;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.utilities.Utility;

class ProdosIndexSector
extends AbstractSector {
    private final String name;

    ProdosIndexSector(String name, Disk disk, byte[] buffer, DiskAddress diskAddress) {
        super(disk, buffer, diskAddress);
        this.name = name;
    }

    @Override
    public String createText() {
        StringBuilder text = this.getHeader("Prodos Index Block : " + this.name);
        int i = 0;
        while (i < 256) {
            text.append(String.format("%02X        %02X %02X", i, this.buffer[i], this.buffer[i + 256]));
            if (this.buffer[i] != 0 || this.buffer[i + 256] != 0) {
                int blockNo = Utility.intValue(this.buffer[i], this.buffer[i + 256]);
                String valid = this.disk.isValidAddress(blockNo) ? "" : " *** invalid ***";
                text.append(String.format("         %s%s%n", "block " + blockNo, valid));
            } else {
                text.append("\n");
            }
            ++i;
        }
        if (text.length() > 0) {
            text.deleteCharAt(text.length() - 1);
        }
        return text.toString();
    }
}

