/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.pascal;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.pascal.PascalDisk;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;

abstract class CatalogEntry
implements AppleFileSource {
    protected AbstractFile file;
    protected final PascalDisk parent;
    protected String name;
    protected int firstBlock;
    protected int lastBlock;
    protected int fileType;
    protected GregorianCalendar date;
    protected int bytesUsedInLastBlock;
    protected final List<DiskAddress> blocks = new ArrayList<DiskAddress>();

    CatalogEntry(PascalDisk parent, byte[] buffer) {
        this.parent = parent;
        this.firstBlock = Utility.getShort(buffer, 0);
        this.lastBlock = Utility.getShort(buffer, 2);
        this.fileType = buffer[4] & 0xFF;
        this.name = HexFormatter.getPascalString(buffer, 6);
        this.bytesUsedInLastBlock = Utility.getShort(buffer, 16);
        Disk disk = parent.getDisk();
        int max = Math.min(this.lastBlock, disk.getTotalBlocks());
        int i = this.firstBlock;
        while (i < max) {
            this.blocks.add(disk.getDiskAddress(i));
            ++i;
        }
    }

    @Override
    public boolean contains(DiskAddress da) {
        for (DiskAddress sector : this.blocks) {
            if (!sector.matches(da)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<DiskAddress> getSectors() {
        return new ArrayList<DiskAddress>(this.blocks);
    }

    @Override
    public FormattedDisk getFormattedDisk() {
        return this.parent;
    }

    @Override
    public String getUniqueName() {
        return this.name;
    }

    public String toString() {
        int size = this.lastBlock - this.firstBlock;
        String fileTypeText = this.fileType < 0 || this.fileType >= this.parent.fileTypes.length ? "????" : this.parent.fileTypes[this.fileType];
        return String.format("%03d  %s  %-15s", size, fileTypeText, this.name);
    }
}

