/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.nufx;

import com.bytezone.diskbrowser.nufx.LZW;
import com.bytezone.diskbrowser.nufx.LZW1;
import com.bytezone.diskbrowser.nufx.LZW2;
import com.bytezone.diskbrowser.utilities.Utility;

class Thread {
    private static String[] threadClassText = new String[]{"Message", "Control", "Data", "Filename"};
    private static String[] formatText = new String[]{"Uncompressed", "Huffman squeeze", "LZW/1", "LZW/2", "Unix 12-bit Compress", "Unix 16-bit Compress"};
    private static String[][] threadKindText = new String[][]{{"ASCII text", "predefined EOF", "IIgs icon"}, {"create directory", "undefined", "undefined"}, {"data fork", "disk image", "resource fork"}, {"filename", "undefined", "undefined"}};
    private static final int DATA_FORK = 0;
    private static final int DISK_IMAGE = 1;
    private static final int RESOURCEFORK = 2;
    final int threadClass;
    final int threadFormat;
    final int threadKind;
    final int threadCrc;
    final int uncompressedEOF;
    final int compressedEOF;
    private final byte[] data;
    private String fileName;
    private String message;
    private LZW lzw;
    private boolean hasDisk;
    private boolean hasFile;
    private boolean hasResource;
    private boolean hasFileName;

    public Thread(byte[] buffer, int offset, int dataOffset) {
        this.threadClass = Utility.getShort(buffer, offset);
        this.threadFormat = Utility.getShort(buffer, offset + 2);
        this.threadKind = Utility.getShort(buffer, offset + 4);
        this.threadCrc = Utility.getShort(buffer, offset + 6);
        this.uncompressedEOF = Utility.getLong(buffer, offset + 8);
        this.compressedEOF = Utility.getLong(buffer, offset + 12);
        this.data = new byte[this.compressedEOF];
        System.arraycopy(buffer, dataOffset, this.data, 0, this.data.length);
        switch (this.threadFormat) {
            case 0: {
                break;
            }
            case 1: {
                System.out.printf("Huffman squeeze", new Object[0]);
                break;
            }
            case 2: {
                this.lzw = new LZW1(this.data);
                break;
            }
            case 3: {
                int crcLength = this.threadKind == 1 ? 0 : this.uncompressedEOF;
                this.lzw = new LZW2(this.data, this.threadCrc, crcLength);
                break;
            }
            case 4: {
                break;
            }
        }
        block7 : switch (this.threadClass) {
            case 0: {
                switch (this.threadKind) {
                    case 0: {
                        break block7;
                    }
                    case 1: {
                        this.message = new String(this.data, 0, this.uncompressedEOF);
                        break block7;
                    }
                }
                break;
            }
            case 1: {
                switch (this.threadKind) {
                    case 0: {
                        break block7;
                    }
                }
                break;
            }
            case 2: {
                switch (this.threadKind) {
                    case 0: {
                        this.hasFile = true;
                        break;
                    }
                    case 1: {
                        this.hasDisk = true;
                        break;
                    }
                    case 2: {
                        this.hasResource = true;
                    }
                }
                break;
            }
            case 3: {
                switch (this.threadKind) {
                    case 0: {
                        this.hasFileName = true;
                        this.fileName = new String(this.data, 0, this.uncompressedEOF);
                        break block7;
                    }
                    case 1: {
                        break block7;
                    }
                }
                break;
            }
            default: {
                System.out.println("Unknown threadClass: " + this.threadClass);
            }
        }
    }

    boolean hasFile(String fileName) {
        return this.threadClass == 3 && this.fileName != null && this.fileName.equals(fileName);
    }

    public byte[] getData() {
        if (this.threadFormat == 0) {
            return this.data;
        }
        return this.lzw.getData();
    }

    int getCompressedEOF() {
        return this.compressedEOF;
    }

    int getUncompressedEOF() {
        return this.uncompressedEOF;
    }

    public boolean hasDisk() {
        return this.hasDisk;
    }

    public boolean hasFile() {
        return this.hasFile;
    }

    public boolean hasResource() {
        return this.hasResource;
    }

    public boolean hasFileName() {
        return this.hasFileName;
    }

    String getFileName() {
        return this.fileName;
    }

    int getFileSize() {
        return this.lzw != null ? this.lzw.getSize() : this.uncompressedEOF;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(String.format("  threadClass ....... %d  %s%n", this.threadClass, threadClassText[this.threadClass]));
        text.append(String.format("  format ............ %d  %s%n", this.threadFormat, formatText[this.threadFormat]));
        text.append(String.format("  kind .............. %d  %s%n", this.threadKind, threadKindText[this.threadClass][this.threadKind]));
        text.append(String.format("  crc ............... %,d  (%<04X)%n", this.threadCrc));
        text.append(String.format("  uncompressedEOF ... %,d  (%<08X)%n", this.uncompressedEOF));
        text.append(String.format("  compressedEOF ..... %,d  (%<08X)", this.compressedEOF));
        if (this.fileName != null) {
            text.append("\n  filename .......... " + this.fileName);
        } else if (this.message != null) {
            text.append("\n  message ........... " + this.message);
        } else if (this.lzw != null) {
            text.append("\n");
            text.append(this.lzw);
        }
        return text.toString();
    }
}

