/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.nufx;

import com.bytezone.diskbrowser.nufx.Thread;
import com.bytezone.diskbrowser.prodos.ProdosConstants;
import com.bytezone.diskbrowser.utilities.DateTime;
import com.bytezone.diskbrowser.utilities.FileFormatException;
import com.bytezone.diskbrowser.utilities.Utility;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

class Record {
    private static final byte[] NuFX = new byte[]{78, -11, 70, -40};
    private static String[] fileSystems = new String[]{"", "ProDOS/SOS", "DOS 3.3", "DOS 3.2", "Apple II Pascal", "Macintosh HFS", "Macintosh MFS", "Lisa File System", "Apple CP/M", "", "MS-DOS", "High Sierra", "ISO 9660", "AppleShare"};
    private static String[] storage = new String[]{"", "Seedling", "Sapling", "Tree", "", "Extended", "", "", "", "", "", "", "", "Subdirectory"};
    private static String[] accessChars = new String[]{"D", "R", "B", "", "", "I", "W", "R"};
    private static String[] threadFormats = new String[]{"unc", "sq ", "lz1", "lz2", "", ""};
    private final int totThreads;
    private final int crc;
    private final char separator;
    private final int fileSystemID;
    private final int attributes;
    private final int version;
    private final int access;
    private final int fileType;
    private final int auxType;
    private final int storType;
    private final DateTime created;
    private final DateTime modified;
    private final DateTime archived;
    private final int optionSize;
    private final int fileNameLength;
    private final String fileName;
    final List<Thread> threads = new ArrayList<Thread>();

    public Record(byte[] buffer, int dataPtr) throws FileFormatException {
        if (!Utility.isMagic(buffer, dataPtr, NuFX)) {
            throw new FileFormatException("NuFX not found");
        }
        this.crc = Utility.getShort(buffer, dataPtr + 4);
        this.attributes = Utility.getShort(buffer, dataPtr + 6);
        this.version = Utility.getShort(buffer, dataPtr + 8);
        this.totThreads = Utility.getLong(buffer, dataPtr + 10);
        this.fileSystemID = Utility.getShort(buffer, dataPtr + 14);
        this.separator = (char)(buffer[dataPtr + 16] & 0xFF);
        this.access = Utility.getLong(buffer, dataPtr + 18);
        this.fileType = Utility.getLong(buffer, dataPtr + 22);
        this.auxType = Utility.getLong(buffer, dataPtr + 26);
        this.storType = Utility.getShort(buffer, dataPtr + 30);
        this.created = new DateTime(buffer, dataPtr + 32);
        this.modified = new DateTime(buffer, dataPtr + 40);
        this.archived = new DateTime(buffer, dataPtr + 48);
        this.optionSize = Utility.getShort(buffer, dataPtr + 56);
        this.fileNameLength = Utility.getShort(buffer, dataPtr + this.attributes - 2);
        int len = this.attributes + this.fileNameLength - 6;
        byte[] crcBuffer = new byte[len + this.totThreads * 16];
        System.arraycopy(buffer, dataPtr + 6, crcBuffer, 0, crcBuffer.length);
        if (this.crc != Utility.getCRC(crcBuffer, crcBuffer.length, 0)) {
            System.out.println("***** Record CRC mismatch *****");
            throw new FileFormatException("Record CRC failed");
        }
        if (this.fileNameLength > 0) {
            int start = dataPtr + this.attributes;
            int end = start + this.fileNameLength;
            int i = start;
            while (i < end) {
                int n = i++;
                buffer[n] = (byte)(buffer[n] & 0x7F);
            }
            this.fileName = new String(buffer, start, this.fileNameLength);
        } else {
            this.fileName = "";
        }
    }

    boolean isValidFileSystem() {
        return this.fileSystemID <= 4 || this.fileSystemID == 8;
    }

    int getAttributes() {
        return this.attributes;
    }

    int getFileNameLength() {
        return this.fileNameLength;
    }

    int getTotalThreads() {
        return this.totThreads;
    }

    boolean hasDisk() {
        for (Thread thread : this.threads) {
            if (!thread.hasDisk()) continue;
            return true;
        }
        return false;
    }

    boolean hasFile() {
        for (Thread thread : this.threads) {
            if (!thread.hasFile()) continue;
            return true;
        }
        return false;
    }

    boolean hasFile(String fileName) {
        for (Thread thread : this.threads) {
            if (!thread.hasFile(fileName)) continue;
            return true;
        }
        return false;
    }

    boolean hasResource() {
        for (Thread thread : this.threads) {
            if (!thread.hasResource()) continue;
            return true;
        }
        return false;
    }

    String getFileName() {
        if (this.fileNameLength > 0) {
            return this.fileName;
        }
        for (Thread thread : this.threads) {
            if (!thread.hasFileName()) continue;
            String fileName = thread.getFileName();
            if (this.separator != '/') {
                return fileName.replace(this.separator, '/');
            }
            return thread.getFileName();
        }
        return "";
    }

    int getFileType() {
        return this.fileType;
    }

    int getAuxType() {
        return this.auxType;
    }

    LocalDateTime getCreated() {
        return this.created == null ? null : this.created.getLocalDateTime();
    }

    LocalDateTime getModified() {
        return this.modified == null ? null : this.modified.getLocalDateTime();
    }

    LocalDateTime getArchived() {
        return this.archived == null ? null : this.archived.getLocalDateTime();
    }

    int getFileSystemID() {
        return this.fileSystemID;
    }

    String getFileSystemName() {
        return fileSystems[this.fileSystemID];
    }

    int getFileSize() {
        for (Thread thread : this.threads) {
            if (!thread.hasFile()) continue;
            return thread.getFileSize();
        }
        return 0;
    }

    int getThreadFormat() {
        for (Thread thread : this.threads) {
            if (!thread.hasFile() && !thread.hasDisk()) continue;
            return thread.threadFormat;
        }
        return 0;
    }

    int getUncompressedSize() {
        if (this.hasDisk()) {
            return this.auxType * this.storType;
        }
        int size = 0;
        for (Thread thread : this.threads) {
            if (!thread.hasFile() && !thread.hasResource() && !thread.hasDisk()) continue;
            size += thread.getUncompressedEOF();
        }
        return size;
    }

    int getCompressedSize() {
        int size = 0;
        for (Thread thread : this.threads) {
            if (!thread.hasFile() && !thread.hasResource() && !thread.hasDisk()) continue;
            size += thread.getCompressedEOF();
        }
        return size;
    }

    byte[] getData() {
        for (Thread thread : this.threads) {
            if (!thread.hasFile()) continue;
            return thread.getData();
        }
        return null;
    }

    byte[] getResourceData() {
        for (Thread thread : this.threads) {
            if (!thread.hasResource()) continue;
            return thread.getData();
        }
        return null;
    }

    String getLine() {
        String forkedFlag;
        String name = this.getFileName();
        if (name.length() > 27) {
            name = ".." + name.substring(name.length() - 25);
        }
        float pct = 100.0f;
        if (this.getUncompressedSize() > 0) {
            pct = this.getCompressedSize() * 100 / this.getUncompressedSize();
        }
        String lockedFlag = (this.access | 0xC3) == 1 ? "+" : " ";
        String string = forkedFlag = this.hasResource() ? "+" : " ";
        if (this.hasDisk()) {
            return String.format("%s%-27.27s %-4s %-6s %-15s  %s  %3.0f%%   %7d", lockedFlag, name, "Disk", String.valueOf(this.getUncompressedSize() / 1024) + "k", this.archived.format2(), threadFormats[this.getThreadFormat()], Float.valueOf(pct), this.getUncompressedSize());
        }
        return String.format("%s%-27.27s %s%s $%04X  %-15s  %s  %3.0f%%   %7d", lockedFlag, name, ProdosConstants.fileTypes[this.fileType], forkedFlag, this.auxType, this.archived.format2(), threadFormats[this.getThreadFormat()], Float.valueOf(pct), this.getUncompressedSize());
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        String bits = "00000000" + Integer.toBinaryString(this.access & 0xFF);
        bits = bits.substring(bits.length() - 8);
        String decode = Utility.matchFlags(this.access, accessChars);
        text.append(String.format("Header CRC ..... %,d  (%<04X)%n", this.crc));
        text.append(String.format("Attributes ..... %d%n", this.attributes));
        text.append(String.format("Version ........ %d%n", this.version));
        text.append(String.format("Threads ........ %d%n", this.totThreads));
        text.append(String.format("File sys id .... %d (%s)%n", this.fileSystemID, this.getFileSystemName()));
        text.append(String.format("Separator ...... %s%n", Character.valueOf(this.separator)));
        text.append(String.format("Access ......... %s  %s%n", bits, decode));
        if (this.storType < 16) {
            text.append(String.format("File type ...... %02X     %s%n", this.fileType, ProdosConstants.fileTypes[this.fileType]));
            text.append(String.format("Aux type ....... %,d  $%<04X%n", this.auxType));
            text.append(String.format("Stor type ...... %,d  %s%n", this.storType, storage[this.storType]));
        } else {
            text.append(String.format("Zero ........... %,d%n", this.fileType));
            text.append(String.format("Total blocks ... %,d%n", this.auxType));
            text.append(String.format("Block size ..... %,d%n", this.storType));
        }
        text.append(String.format("Created ........ %s%n", this.created.format()));
        text.append(String.format("Modified ....... %s%n", this.modified.format()));
        text.append(String.format("Archived ....... %s%n", this.archived.format()));
        text.append(String.format("Option size .... %,d%n", this.optionSize));
        text.append(String.format("Filename len ... %,d%n", this.fileNameLength));
        text.append(String.format("Filename ....... %s", this.fileName));
        return text.toString();
    }
}

