/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.nufx;

import com.bytezone.diskbrowser.nufx.MasterHeader;
import com.bytezone.diskbrowser.nufx.Record;
import com.bytezone.diskbrowser.nufx.Thread;
import com.bytezone.diskbrowser.prodos.write.DiskFullException;
import com.bytezone.diskbrowser.prodos.write.FileAlreadyExistsException;
import com.bytezone.diskbrowser.prodos.write.FileEntry;
import com.bytezone.diskbrowser.prodos.write.ProdosDisk;
import com.bytezone.diskbrowser.prodos.write.VolumeCatalogFullException;
import com.bytezone.diskbrowser.utilities.FileFormatException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

public class NuFX {
    private static final String UNDERLINE = "-----------------------------------------------------------------------------";
    private MasterHeader masterHeader;
    private final byte[] buffer;
    private final boolean debug = false;
    private final List<Record> records = new ArrayList<Record>();
    private int totalFiles;
    private int totalDisks;
    private int totalBlocks;
    private VolumeName volumeName;

    public NuFX(Path path) throws FileFormatException, IOException {
        this.buffer = Files.readAllBytes(path);
        this.volumeName = new VolumeName(path.getFileName().toString());
        this.read(this.buffer);
    }

    public NuFX(byte[] buffer, String fileName) {
        this.buffer = buffer;
        this.volumeName = new VolumeName(fileName);
        this.read(buffer);
    }

    void read(byte[] buffer) {
        this.masterHeader = new MasterHeader(buffer);
        int dataPtr = this.masterHeader.bin2 ? 176 : 48;
        int rec = 0;
        while (rec < this.masterHeader.getTotalRecords()) {
            Record record = new Record(buffer, dataPtr);
            this.records.add(record);
            int threadsPtr = dataPtr += record.getAttributes() + record.getFileNameLength();
            dataPtr += record.getTotalThreads() * 16;
            int i = 0;
            while (i < record.getTotalThreads()) {
                Thread thread = new Thread(buffer, threadsPtr + i * 16, dataPtr);
                record.threads.add(thread);
                dataPtr += thread.getCompressedEOF();
                ++i;
            }
            if (record.hasFile()) {
                ++this.totalFiles;
                this.volumeName.storePath(record.getFileName());
            }
            if (record.hasDisk()) {
                ++this.totalDisks;
            }
            ++rec;
        }
    }

    private void calculateTotalBlocks() {
        this.totalBlocks = 0;
        for (Record record : this.records) {
            if (!record.hasFile() && !record.hasResource()) continue;
            int blocks = (record.getUncompressedSize() - 1) / 512 + 1;
            if (blocks == 1) {
                this.totalBlocks += blocks;
                continue;
            }
            if (blocks <= 256) {
                this.totalBlocks += blocks + 1;
                continue;
            }
            this.totalBlocks += blocks + blocks / 256 + 2;
        }
    }

    public byte[] getDiskBuffer() {
        int[] diskSizes;
        if (this.totalDisks > 0) {
            for (Record record : this.records) {
                for (Thread thread : record.threads) {
                    if (!thread.hasDisk()) continue;
                    return thread.getData();
                }
            }
        }
        if (this.totalFiles == 0) {
            return null;
        }
        this.calculateTotalBlocks();
        int[] nArray = diskSizes = new int[]{280, 800, 1600, 3200, 6400, 65536};
        int n = diskSizes.length;
        int n2 = 0;
        while (n2 < n) {
            int diskSize = nArray[n2];
            if (diskSize >= this.totalBlocks + 10) {
                try {
                    ProdosDisk disk = new ProdosDisk(diskSize, this.volumeName.getVolumeName());
                    boolean count = false;
                    for (Record record : this.records) {
                        FileEntry fileEntry;
                        byte[] buffer;
                        if (!record.hasFile()) continue;
                        String fileName = this.volumeName.convert(record.getFileName());
                        if (!record.isValidFileSystem()) {
                            System.out.printf("File %s is file system %s%n", fileName, record.getFileSystemName());
                            continue;
                        }
                        byte fileType = (byte)record.getFileType();
                        int eof = record.getUncompressedSize();
                        int auxType = record.getAuxType();
                        LocalDateTime created = record.getCreated();
                        LocalDateTime modified = record.getModified();
                        try {
                            buffer = record.getData();
                        }
                        catch (Exception e) {
                            System.out.println(e.getMessage());
                            System.out.printf("Failed to unpack: %s%n", fileName);
                            continue;
                        }
                        try {
                            fileEntry = disk.addFile(fileName, fileType, auxType, created, modified, buffer, eof);
                        }
                        catch (FileAlreadyExistsException e) {
                            System.out.printf("File %s not added%n", fileName);
                            break;
                        }
                        if (!record.hasResource()) continue;
                        try {
                            buffer = record.getResourceData();
                            disk.addResourceFork(fileEntry, buffer, buffer.length);
                        }
                        catch (Exception e) {
                            System.out.println(e.getMessage());
                            System.out.printf("Failed to unpack resource fork: %s%n", fileName);
                        }
                    }
                    disk.close();
                    return disk.getBuffer();
                }
                catch (DiskFullException e) {
                    System.out.println("disk full: " + diskSize);
                }
                catch (VolumeCatalogFullException e) {
                    e.printStackTrace();
                    return null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            ++n2;
        }
        return null;
    }

    public int getTotalFiles() {
        return this.totalFiles;
    }

    public int getTotalDisks() {
        return this.totalDisks;
    }

    public int getTotalBlocks() {
        return this.totalBlocks;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(String.format(" %-15.15s Created:%-17s Mod:%-17s   Recs:%5d%n%n", this.volumeName.volumeName, this.masterHeader.getCreated2(), this.masterHeader.getModified2(), this.masterHeader.getTotalRecords()));
        text.append(" Name                        Type Auxtyp Archived         Fmat Size Un-Length\n");
        text.append(String.format("%s%n", UNDERLINE));
        int totalUncompressedSize = 0;
        int totalCompressedSize = 0;
        for (Record record : this.records) {
            text.append(String.format("%s%n", record.getLine()));
            totalUncompressedSize += record.getUncompressedSize();
            totalCompressedSize += record.getCompressedSize();
        }
        text.append(String.format("%s%n", UNDERLINE));
        float pct = 0.0f;
        if (totalUncompressedSize > 0) {
            pct = totalCompressedSize * 100 / totalUncompressedSize;
        }
        text.append(String.format(" Uncomp:%7d  Comp:%7d  %%of orig:%3.0f%%%n%n", totalUncompressedSize, totalCompressedSize, Float.valueOf(pct)));
        return text.toString();
    }

    class VolumeName {
        private List<String> paths = new ArrayList<String>();
        private boolean rootContainsFiles;
        private String volumeName = "DiskBrowser";
        private int nameOffset = 0;

        VolumeName(String name) {
            int pos = name.lastIndexOf(46);
            if (pos > 0) {
                name = name.substring(0, pos);
            }
            if (name.length() > 15) {
                name = name.substring(0, 15);
            }
            this.volumeName = name = name.replace(' ', '.');
        }

        private void storePath(String fileName) {
            int pos = fileName.lastIndexOf(47);
            if (pos < 0) {
                this.rootContainsFiles = true;
            } else {
                String path = fileName.substring(0, pos);
                int i = 0;
                while (i < this.paths.size()) {
                    String cmp = this.paths.get(i);
                    if (cmp.startsWith(path)) {
                        return;
                    }
                    if (path.startsWith(cmp)) {
                        this.paths.set(i, path);
                        return;
                    }
                    ++i;
                }
                this.paths.add(path);
            }
        }

        private String getVolumeName() {
            int pos;
            if (this.rootContainsFiles) {
                return this.volumeName;
            }
            if (this.paths.size() > 0 && (pos = this.paths.get(0).indexOf(47)) > 0) {
                String firstPath = this.paths.get(0).substring(0, pos + 1);
                boolean allSame = true;
                for (String pathName : this.paths) {
                    if (pathName.startsWith(firstPath)) continue;
                    allSame = false;
                    break;
                }
                if (allSame) {
                    this.volumeName = firstPath.substring(0, pos);
                    this.nameOffset = this.volumeName.length() + 1;
                }
            }
            if (this.paths.size() == 1) {
                String onlyPath = this.paths.get(0);
                int pos2 = onlyPath.indexOf(47);
                this.volumeName = pos2 == -1 ? onlyPath : onlyPath.substring(0, pos2);
                this.nameOffset = this.volumeName.length() + 1;
            }
            return this.volumeName;
        }

        String convert(String fileName) {
            if (this.nameOffset > 0) {
                return fileName.substring(this.nameOffset);
            }
            return fileName;
        }

        void info() {
            if (this.rootContainsFiles) {
                System.out.println("Root contains files");
            }
            System.out.println("Unique paths:");
            if (this.paths.size() == 0) {
                System.out.println("<none>");
            }
            for (String pathName : this.paths) {
                System.out.println(pathName);
            }
        }
    }
}

