/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.nufx;

import com.bytezone.diskbrowser.nufx.LZW;
import com.bytezone.diskbrowser.utilities.Utility;

class LZW2
extends LZW {
    private int nextEntry = 256;
    private String prev = "";
    private int codeWord;

    public LZW2(byte[] buffer, int crc, int eof) {
        super(buffer);
        this.crc = crc;
        this.v3eof = eof;
    }

    @Override
    void unpack() {
        this.crcBase = 65535;
        this.codeWord = 0;
        this.volume = this.buffer[0] & 0xFF;
        this.runLengthChar = (byte)(this.buffer[1] & 0xFF);
        int ptr = 2;
        while (ptr < this.buffer.length - 1) {
            int rleLength = Utility.getShort(this.buffer, ptr);
            boolean lzwPerformed = (rleLength & 0x8000) != 0;
            ptr += 2;
            if (lzwPerformed) {
                if ((rleLength &= 0xFFF) == 0) {
                    rleLength = 4096;
                }
                int chunkLength = Utility.getShort(this.buffer, ptr);
                this.setBuffer(ptr += 2);
                byte[] lzwBuffer = this.undoLZW(rleLength);
                if (chunkLength - 4 != this.bytesRead()) {
                    System.out.printf("Invalid chunk length%n", new Object[0]);
                }
                if (rleLength == 4096) {
                    this.chunks.add(lzwBuffer);
                } else {
                    this.chunks.add(this.undoRLE(lzwBuffer, 0, lzwBuffer.length));
                }
                ptr += this.bytesRead();
                continue;
            }
            this.nextEntry = 256;
            if (rleLength == 0) {
                rleLength = 4096;
            }
            if (rleLength == 4096) {
                byte[] originalBuffer = new byte[4096];
                System.arraycopy(this.buffer, ptr, originalBuffer, 0, originalBuffer.length);
                this.chunks.add(originalBuffer);
            } else {
                this.chunks.add(this.undoRLE(this.buffer, ptr, rleLength));
            }
            ptr += rleLength;
        }
    }

    byte[] undoLZW(int rleLength) {
        byte[] lzwBuffer = new byte[rleLength];
        int ptr = 0;
        while (ptr < rleLength) {
            String s;
            this.codeWord = this.readInt(this.width(this.nextEntry + 1));
            if (this.codeWord == 256) {
                this.nextEntry = 256;
                this.codeWord = this.readInt(9);
                this.prev = "";
            }
            String string = s = this.nextEntry == this.codeWord ? String.valueOf(this.prev) + this.prev.charAt(0) : st[this.codeWord];
            if (this.nextEntry < st.length) {
                LZW2.st[this.nextEntry++] = String.valueOf(this.prev) + s.charAt(0);
            }
            int i = 0;
            while (i < s.length()) {
                lzwBuffer[ptr++] = (byte)s.charAt(i);
                ++i;
            }
            this.prev = s;
        }
        return lzwBuffer;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(String.format("  volume ............ %,d%n", this.volume));
        text.append(String.format("  RLE char .......... $%02X", this.runLengthChar));
        return text.toString();
    }
}

