/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.nufx;

import com.bytezone.diskbrowser.prodos.ProdosConstants;
import com.bytezone.diskbrowser.prodos.write.ProdosDisk;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class Binary2Header {
    static DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-LLL-yy HH:mm");
    static String[] osTypes = new String[]{"Prodos", "DOS 3.3", "Reserved", "DOS 3.2 or 3.1", "Pascal", "Macintosh MFS", "Macintosh HFS", "Lisa", "CPM", "Reserved", "MS-DOS", "High Sierra (CD-ROM)", "ISO 9660 (CD-ROM)", "AppleShare"};
    int ptr;
    byte[] buffer;
    int accessCode;
    byte fileType;
    int auxType;
    int storageType;
    int totalBlocks;
    LocalDateTime modified;
    LocalDateTime created;
    int id;
    int eof;
    String fileName;
    String nativeFileName;
    int prodos16accessCode;
    int prodos16fileType;
    int prodos16storageType;
    int prodos16totalBlocks;
    int prodos16eof;
    long diskSpaceRequired;
    int osType;
    int nativeFileType;
    int phantomFileFlag;
    int dataFlags;
    int version;
    int filesToFollow;
    boolean compressed;
    boolean encrypted;
    boolean sparsePacked;

    public Binary2Header(byte[] buffer, int ptr) {
        this.ptr = ptr;
        this.buffer = buffer;
        this.accessCode = buffer[ptr + 3] & 0xFF;
        this.fileType = buffer[ptr + 4];
        this.auxType = Utility.getShort(buffer, ptr + 5);
        this.storageType = buffer[ptr + 7] & 0xFF;
        this.totalBlocks = Utility.getShort(buffer, ptr + 8);
        this.modified = Utility.getAppleDate(buffer, ptr + 10);
        this.created = Utility.getAppleDate(buffer, ptr + 14);
        this.id = buffer[ptr + 18] & 0xFF;
        this.eof = Utility.readTriple(buffer, ptr + 20);
        this.fileName = HexFormatter.getPascalString(buffer, ptr + 23);
        this.prodos16accessCode = buffer[ptr + 111] & 0xFF;
        this.prodos16fileType = buffer[ptr + 112] & 0xFF;
        this.prodos16storageType = buffer[113] & 0xFF;
        this.prodos16totalBlocks = Utility.getShort(buffer, ptr + 114);
        this.prodos16eof = buffer[ptr + 116] & 0xFF;
        this.diskSpaceRequired = Utility.getLong(buffer, ptr + 117);
        this.osType = buffer[ptr + 121] & 0xFF;
        this.nativeFileType = Utility.getShort(buffer, ptr + 122);
        this.phantomFileFlag = buffer[ptr + 124] & 0xFF;
        this.dataFlags = buffer[ptr + 125] & 0xFF;
        this.version = buffer[ptr + 126] & 0xFF;
        this.filesToFollow = buffer[ptr + 127] & 0xFF;
        this.compressed = (this.dataFlags & 0x80) != 0;
        this.encrypted = (this.dataFlags & 0x40) != 0;
        this.sparsePacked = (this.dataFlags & 1) != 0;
    }

    public String getLine() {
        return String.format(" %-33s %3s  $%04X  %s  unc   %7d", this.fileName, ProdosConstants.fileTypes[this.fileType], this.auxType, this.modified.format(formatter), this.eof);
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("Binary2 Header\n==============\n");
        text.append(String.format("Access ................ %02X%n", this.accessCode));
        text.append(String.format("File type ............. %02X%n", this.fileType));
        text.append(String.format("Aux type .............. %04X%n", this.auxType));
        text.append(String.format("Storage type .......... %02X  %s%n", this.storageType, ProdosDisk.storageTypes[this.storageType]));
        text.append(String.format("Total blocks .......... %04X  %<,d%n", this.totalBlocks));
        text.append(String.format("Modified .............. %s%n", this.modified));
        text.append(String.format("Created ............... %s%n", this.created));
        text.append(String.format("ID (0x02) ............. %02X%n", this.id));
        text.append(String.format("End of file ........... %06X  %<,d%n", this.eof));
        text.append(String.format("File name ............. %s%n", this.fileName));
        text.append(String.format("Prodos access ......... %02X%n", this.prodos16accessCode));
        text.append(String.format("Prodos file type ...... %02X%n", this.prodos16fileType));
        text.append(String.format("Prodos storage type ... %02X%n", this.prodos16storageType));
        text.append(String.format("Prodos total blocks ... %02X%n", this.prodos16totalBlocks));
        text.append(String.format("Prodos eof ............ %06X  %<,d%n", this.prodos16eof));
        text.append(String.format("Disk space needed ..... %08X  %<,d%n", this.diskSpaceRequired));
        text.append(String.format("OS type ............... %02X  %s%n", this.osType, osTypes[this.osType]));
        text.append(String.format("Native file type ...... %02X%n", this.nativeFileType));
        text.append(String.format("Data flags ............ %02X%n", this.dataFlags));
        text.append(String.format("Version ............... %02X%n", this.version));
        text.append(String.format("Following files ....... %02X%n", this.filesToFollow));
        return text.toString();
    }
}

