/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.nufx;

import com.bytezone.diskbrowser.nufx.Binary2Header;
import com.bytezone.diskbrowser.prodos.write.DiskFullException;
import com.bytezone.diskbrowser.prodos.write.FileAlreadyExistsException;
import com.bytezone.diskbrowser.prodos.write.ProdosDisk;
import com.bytezone.diskbrowser.prodos.write.VolumeCatalogFullException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class Binary2 {
    private static final String UNDERLINE = "-----------------------------------------------------------------------------";
    Binary2Header binary2Header;
    byte[] buffer;
    List<Binary2Header> headers = new ArrayList<Binary2Header>();
    int totalBlocks;
    String fileName;

    public Binary2(Path path) throws IOException {
        this.fileName = path.toFile().getName();
        this.buffer = Files.readAllBytes(path);
        this.read(this.buffer);
    }

    private void read(byte[] buffer) {
        int ptr = 0;
        do {
            this.binary2Header = new Binary2Header(buffer, ptr);
            System.out.println(this.binary2Header);
            this.headers.add(this.binary2Header);
            this.totalBlocks += this.binary2Header.totalBlocks;
            ptr += ((this.binary2Header.eof - 1) / 128 + 1) * 128 + 128;
        } while (this.binary2Header.filesToFollow > 0);
    }

    public byte[] getDiskBuffer() throws DiskFullException, VolumeCatalogFullException, FileAlreadyExistsException, IOException {
        ProdosDisk disk = new ProdosDisk(800, "DiskBrowser");
        for (Binary2Header header : this.headers) {
            byte[] dataBuffer = new byte[header.eof];
            System.arraycopy(this.buffer, header.ptr + 128, dataBuffer, 0, dataBuffer.length);
            disk.addFile(header.fileName, header.fileType, header.auxType, header.created, header.modified, dataBuffer, header.eof);
        }
        disk.close();
        return disk.getBuffer();
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(String.format(" %-15.15s                                                  Files:%5d%n%n", this.fileName, this.headers.size()));
        text.append(" Name                              Type Auxtyp Modified         Fmat   Length\n");
        text.append(String.format("%s%n", UNDERLINE));
        for (Binary2Header header : this.headers) {
            text.append(String.format("%s%n", header.getLine()));
        }
        text.append(String.format("%s%n", UNDERLINE));
        return text.toString();
    }
}

