/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.nib;

import com.bytezone.diskbrowser.nib.ByteTranslator;
import com.bytezone.diskbrowser.nib.ByteTranslator6and2;
import com.bytezone.diskbrowser.nib.DiskNibbleException;
import com.bytezone.diskbrowser.nib.DiskReader;

class DiskReader16Sector
extends DiskReader {
    private static final int RAW_BUFFER_SIZE = 342;
    private static final int BUFFER_WITH_CHECKSUM_SIZE = 343;
    private final byte[] decodeA = new byte[343];
    private final byte[] decodeB = new byte[342];
    private final byte[] encodeA = new byte[342];
    private final byte[] encodeB = new byte[343];
    private final ByteTranslator byteTranslator = new ByteTranslator6and2();

    DiskReader16Sector() {
        super(16);
    }

    @Override
    byte[] decodeSector(byte[] buffer, int offset) throws DiskNibbleException {
        byte[] decodedBuffer = new byte[256];
        int i = 0;
        while (i < 343) {
            this.decodeA[i] = (byte)(this.byteTranslator.decode(buffer[offset++]) << 2);
            ++i;
        }
        byte chk = 0;
        int i2 = this.decodeB.length - 1;
        while (i2 >= 0) {
            chk = this.decodeB[i2] = (byte)(this.decodeA[i2 + 1] ^ chk);
            --i2;
        }
        if ((chk ^ this.decodeA[0]) != 0) {
            throw new DiskNibbleException("Checksum failed");
        }
        i2 = 0;
        while (i2 < 256) {
            decodedBuffer[i2] = this.decodeB[i2 + 86];
            ++i2;
        }
        i2 = 0;
        int j = 86;
        int k = 172;
        while (i2 < 86) {
            byte val = this.decodeB[i2];
            int n = i2;
            decodedBuffer[n] = (byte)(decodedBuffer[n] | DiskReader16Sector.reverse((val & 0xC) >> 2));
            int n2 = j;
            decodedBuffer[n2] = (byte)(decodedBuffer[n2] | DiskReader16Sector.reverse((val & 0x30) >> 4));
            if (k < 256) {
                int n3 = k;
                decodedBuffer[n3] = (byte)(decodedBuffer[n3] | DiskReader16Sector.reverse((val & 0xC0) >> 6));
            }
            ++i2;
            ++j;
            ++k;
        }
        return decodedBuffer;
    }

    @Override
    byte[] encodeSector(byte[] buffer) {
        byte[] encodedBuffer = new byte[343];
        int i = 0;
        while (i < 256) {
            this.encodeA[i + 86] = buffer[i];
            ++i;
        }
        i = 0;
        while (i < 86) {
            int b1 = DiskReader16Sector.reverse(buffer[i] & 3) << 2;
            int b2 = DiskReader16Sector.reverse(buffer[i + 86] & 3) << 4;
            if (i < 84) {
                int b3 = DiskReader16Sector.reverse(buffer[i + 172] & 3) << 6;
                this.encodeA[i] = (byte)(b1 | b2 | b3);
            } else {
                this.encodeA[i] = (byte)(b1 | b2);
            }
            ++i;
        }
        byte checksum = 0;
        int i2 = 0;
        while (i2 < 342) {
            this.encodeB[i2] = (byte)(checksum ^ this.encodeA[i2]);
            checksum = this.encodeA[i2];
            ++i2;
        }
        this.encodeB[342] = checksum;
        i2 = 0;
        while (i2 < 343) {
            encodedBuffer[i2] = this.byteTranslator.encode(this.encodeB[i2]);
            ++i2;
        }
        return encodedBuffer;
    }
}

