/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.infocom;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.infocom.Header;
import com.bytezone.diskbrowser.infocom.Routine;
import com.bytezone.diskbrowser.infocom.ZString;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

class ZObject
extends AbstractFile
implements Comparable<ZObject> {
    static final int HEADER_SIZE = 9;
    private final Header header;
    private final int id;
    private final int startPtr;
    private final int propertyTablePtr;
    private final int propertyTableLength;
    final int parent;
    final int sibling;
    final int child;
    final List<Property> properties = new ArrayList<Property>();
    final BitSet attributes = new BitSet(32);

    ZObject(String name, byte[] buffer, int offset, int id, Header header) {
        super(name, buffer);
        this.header = header;
        this.startPtr = offset;
        this.id = id;
        int bitIndex = 0;
        int i = 0;
        while (i < 4) {
            byte b = buffer[offset + i];
            int j = 0;
            while (j < 8) {
                if ((b & 0x80) != 0) {
                    this.attributes.set(bitIndex);
                }
                b = (byte)(b << 1);
                ++bitIndex;
                ++j;
            }
            ++i;
        }
        this.parent = header.getByte(offset + 4);
        this.sibling = header.getByte(offset + 5);
        this.child = header.getByte(offset + 6);
        this.propertyTablePtr = header.getWord(offset + 7);
        int ptr = this.propertyTablePtr;
        int nameLength = header.getByte(ptr) * 2;
        this.setName(nameLength == 0 ? "<<" + id + ">>" : new ZString((Header)header, (int)(++ptr)).value);
        ptr += nameLength;
        while (buffer[ptr] != 0) {
            Property p = new Property(ptr);
            this.properties.add(p);
            ptr += p.length + 1;
        }
        this.propertyTableLength = ptr - this.propertyTablePtr;
    }

    int getId() {
        return this.id;
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        text.append(String.format("ID       : %02X  (%<3d)  %s%n%n", this.id, this.getName()));
        String obj1 = this.parent == 0 ? "" : this.header.getObject(this.parent - 1).getName();
        String obj2 = this.sibling == 0 ? "" : this.header.getObject(this.sibling - 1).getName();
        String obj3 = this.child == 0 ? "" : this.header.getObject(this.child - 1).getName();
        text.append(String.format("Parent   : %02X  (%<3d)  %s%n", this.parent, obj1));
        text.append(String.format("Sibling  : %02X  (%<3d)  %s%n", this.sibling, obj2));
        text.append(String.format("Child    : %02X  (%<3d)  %s%n%n", this.child, obj3));
        text.append("Attributes : ");
        text.append(HexFormatter.getHexString(this.buffer, this.startPtr, 4));
        text.append("   " + this.attributes.toString() + "\n\n");
        for (Property prop : this.properties) {
            text.append(prop + "\n");
        }
        return text.toString();
    }

    @Override
    public String getHexDump() {
        StringBuilder text = new StringBuilder("Header :\n\n");
        text.append(HexFormatter.formatNoHeader(this.buffer, this.startPtr, 9));
        text.append("\n\nProperty table:\n\n");
        text.append(HexFormatter.formatNoHeader(this.buffer, this.propertyTablePtr, this.propertyTableLength));
        return text.toString();
    }

    Property getProperty(int id) {
        for (Property p : this.properties) {
            if (p.propertyNumber != id) continue;
            return p;
        }
        return null;
    }

    public String toString() {
        return String.valueOf(HexFormatter.getHexString(this.buffer, this.startPtr, 9)) + "   " + this.getName();
    }

    public String getDescription(List<ZObject> list) {
        StringBuilder text = new StringBuilder(String.format(" %-40s", this.getName()));
        int i = 4;
        while (i < 7) {
            int index = this.buffer[this.startPtr + i] & 0xFF;
            String name = index > 0 ? list.get(index - 1).getName() : "";
            text.append(String.format(" %-40s", name));
            ++i;
        }
        text.append(" ");
        text.append(HexFormatter.getHexString(this.buffer, this.startPtr, 4));
        text.append("  ");
        text.append(HexFormatter.getHexString(this.buffer, this.startPtr + 7, 2));
        return text.toString();
    }

    @Override
    public int compareTo(ZObject o) {
        return this.getName().compareTo(o.getName());
    }

    class Property {
        int propertyNumber;
        int ptr;
        int length;
        int offset;

        public Property(int ptr) {
            this.ptr = ptr;
            this.length = ZObject.this.header.getByte(ptr) / 32 + 1;
            this.propertyNumber = ZObject.this.header.getByte(ptr) % 32;
            if (this.length == 2) {
                this.offset = ZObject.this.header.getWord(ptr + 1) * 2;
            }
        }

        private ZObject getObject() {
            return ZObject.this.header.getObject((ZObject.this.buffer[this.ptr + 1] & 0xFF) - 1);
        }

        private ZObject getObject(int id) {
            return ZObject.this.header.getObject(id - 1);
        }

        public String toString() {
            StringBuilder text;
            block20: {
                String propertyType;
                block19: {
                    text = new StringBuilder(String.format("%8s : ", ZObject.this.header.getPropertyName(this.propertyNumber)));
                    propertyType = ZObject.this.header.getPropertyName(this.propertyNumber);
                    if (!propertyType.equals("DICT") && !propertyType.startsWith("STR")) {
                        text.append(String.format("%-20s", HexFormatter.getHexString(ZObject.this.buffer, this.ptr + 1, this.length)));
                    }
                    if (this.propertyNumber < 19) break block19;
                    ZObject object = this.getObject();
                    String objectName = object == null ? "no object" : object.getName();
                    switch (this.length) {
                        case 1: {
                            text.append(objectName);
                            break;
                        }
                        case 2: {
                            text.append("\"" + ZObject.this.header.stringManager.stringAt(this.offset) + "\"");
                            break;
                        }
                        case 3: {
                            int address = ZObject.this.header.getWord(this.ptr + 1) * 2;
                            text.append(String.format("R:%05X", address));
                            this.appendRoutine(text, address);
                            break;
                        }
                        case 4: {
                            text.append(String.format("%s : IF G%02X ELSE ", objectName, ZObject.this.header.getByte(this.ptr + 2)));
                            int address = ZObject.this.header.getWord(this.ptr + 3) * 2;
                            if (address > 0) {
                                text.append("\"" + ZObject.this.header.stringManager.stringAt(address) + "\"");
                                break;
                            }
                            break block20;
                        }
                        case 5: {
                            text.append(String.format("%s : IF G%02X ", objectName, ZObject.this.header.getByte(this.ptr + 2)));
                            break;
                        }
                    }
                    break block20;
                }
                if (propertyType.equals("DICT")) {
                    int i = 1;
                    while (i <= this.length) {
                        int address = ZObject.this.header.getWord(this.ptr + i);
                        text.append(String.format("%02X: %s, ", address, ZObject.this.header.wordAt(address)));
                        i += 2;
                    }
                    text.deleteCharAt(text.length() - 1);
                    text.deleteCharAt(text.length() - 1);
                } else if (propertyType.startsWith("CODE")) {
                    if (this.offset > 0) {
                        this.appendRoutine(text, this.offset);
                    }
                } else if (propertyType.startsWith("STR")) {
                    text.append(String.format("(%4X) \"%s\"", this.offset, ZObject.this.header.stringManager.stringAt(this.offset)));
                } else if (!(propertyType.equals("ADJ") || propertyType.equals("SIZE") || propertyType.equals("VALUE") || propertyType.equals("TVALU") || !propertyType.equals("GLBL"))) {
                    int i = 0;
                    while (i < this.length) {
                        int objectId = ZObject.this.header.getByte(this.ptr + i + 1);
                        text.append(String.format("%s%s", i == 0 ? "" : ", ", this.getObject(objectId).getName()));
                        ++i;
                    }
                }
            }
            return text.toString();
        }

        private void appendRoutine(StringBuilder text, int offset) {
            Routine r = ZObject.this.header.codeManager.getRoutine(offset);
            if (r != null) {
                text.append("\n\n" + r.getText());
            } else {
                text.append("\n\n****** null routine\n");
            }
        }
    }
}

