/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.infocom;

import com.bytezone.diskbrowser.infocom.Header;
import com.bytezone.diskbrowser.infocom.InfocomAbstractFile;
import com.bytezone.diskbrowser.infocom.Instruction;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class Routine
extends InfocomAbstractFile
implements Iterable<Instruction>,
Comparable<Routine> {
    int startPtr;
    int length;
    int strings;
    int locals;
    List<Parameter> parameters = new ArrayList<Parameter>();
    List<Instruction> instructions = new ArrayList<Instruction>();
    List<Integer> calls = new ArrayList<Integer>();
    List<Integer> calledBy = new ArrayList<Integer>();
    List<Integer> actions = new ArrayList<Integer>();
    List<Integer> targets = new ArrayList<Integer>();

    Routine(int ptr, Header header, int caller) {
        super(String.format("Routine %05X", ptr), header.buffer);
        Instruction instruction;
        this.locals = this.buffer[ptr] & 0xFF;
        if (this.locals > 15) {
            System.out.println("Too many locals: " + this.locals);
            return;
        }
        this.startPtr = ptr++;
        if (!this.calledBy.contains(caller)) {
            this.calledBy.add(caller);
        }
        int i = 1;
        while (i <= this.locals) {
            this.parameters.add(new Parameter(i, header.getWord(ptr)));
            ptr += 2;
            ++i;
        }
        do {
            if (this.buffer[ptr] == 0 || this.buffer[ptr] == 32 || this.buffer[ptr] == 64) {
                System.out.println("Bad instruction found : " + ptr);
                return;
            }
            instruction = new Instruction(this.buffer, ptr, header);
            this.instructions.add(instruction);
            if (instruction.isCall() && instruction.opcode.callTarget > 0) {
                this.calls.add(instruction.opcode.callTarget);
            }
            if (instruction.isPrint()) {
                ++this.strings;
            }
            if (instruction.isBranch() && !this.targets.contains(instruction.target())) {
                this.targets.add(instruction.target());
            }
            if (instruction.isJump() && !this.targets.contains(instruction.target())) {
                this.targets.add(instruction.target());
            }
            for (Instruction.Operand operand : instruction.opcode.operands) {
                if (operand.operandType != Instruction.OperandType.VAR_GLOBAL) continue;
                header.globals.addRoutine(this, operand);
            }
        } while (this.isTarget(ptr += instruction.length()) || (!instruction.isJump() || instruction.target() >= ptr) && !instruction.isReturn());
        this.length = ptr - this.startPtr;
        this.hexBlocks.add(new InfocomAbstractFile.HexBlock(this.startPtr, this.length, null));
        int endPtr = this.startPtr + this.length;
        for (Instruction instruction2 : this.instructions) {
            int target;
            int n = instruction2.target() > 256 ? instruction2.target() : (target = instruction2.opcode.jumpTarget > 256 ? instruction2.opcode.jumpTarget : 0);
            if (target == 0) continue;
            if (instruction2.isBranch() && (target > endPtr || target < this.startPtr)) {
                System.out.println(instruction2);
            }
            if (!instruction2.isJump() || target <= endPtr && target >= this.startPtr) continue;
            System.out.println(instruction2);
        }
    }

    String dump() {
        StringBuilder text = new StringBuilder();
        text.append(String.format("%05X : %s", this.startPtr, HexFormatter.getHexString(this.buffer, this.startPtr, 1 + this.locals * 2)));
        text.append("\n");
        for (Instruction instruction : this.instructions) {
            text.append(instruction.dump());
            text.append("\n");
        }
        return text.toString();
    }

    boolean isValid() {
        return this.startPtr > 0;
    }

    private boolean isTarget(int ptr) {
        for (Instruction ins : this.instructions) {
            if (ins.isBranch() && ins.target() == ptr) {
                return true;
            }
            if (!ins.isJump() || ins.opcode.jumpTarget != ptr) continue;
            return true;
        }
        return false;
    }

    public void addCaller(int caller) {
        this.calledBy.add(caller);
    }

    @Override
    public String getText() {
        Iterator<Object> iterator;
        StringBuilder text = new StringBuilder();
        text.append(String.format("Called by : %3d%n", this.calledBy.size()));
        text.append(String.format("Calls     : %3d%n", this.calls.size()));
        text.append(String.format("Length    : %3d%n%n", this.length));
        text.append(String.format("%05X : %d%n", this.startPtr, this.locals));
        for (Parameter parameter : this.parameters) {
            text.append(String.valueOf(parameter.toString()) + "\n");
        }
        text.append("\n");
        for (Instruction instruction : this.instructions) {
            text.append(instruction.getHex());
            int offset = instruction.startPtr;
            if (this.targets.contains(offset)) {
                text.append("  L000 ");
            } else {
                text.append("       ");
            }
            text.append(instruction + "\n");
        }
        if (this.calledBy.size() > 0) {
            text.append("\n\nCalled by\n\n");
            iterator = this.calledBy.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                text.append(String.format("%05X%n", i));
            }
        }
        if (this.calls.size() > 0) {
            text.append("\n\nCalls\n\n");
            iterator = this.calls.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                text.append(String.format("%05X%n", i));
            }
        }
        if (this.targets.size() > 0) {
            text.append("\n\nTargets\n\n");
            iterator = this.targets.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                text.append(String.format("%05X%n", i));
            }
        }
        return text.toString();
    }

    public String toString() {
        return String.format("[Start: %05X, Len: %4d, Strings: %2d, Locals: %2d]", this.startPtr, this.length, this.strings, this.locals);
    }

    @Override
    public Iterator<Instruction> iterator() {
        return this.instructions.iterator();
    }

    @Override
    public int compareTo(Routine o) {
        return this.startPtr - o.startPtr;
    }

    class Parameter {
        int value;
        int sequence;

        public Parameter(int sequence, int value) {
            this.value = value;
            this.sequence = sequence;
        }

        public String toString() {
            return String.format("%05X : L%02d : %d", Routine.this.startPtr + (this.sequence - 1) * 2 + 1, this.sequence, this.value);
        }
    }
}

