/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.infocom;

import com.bytezone.diskbrowser.infocom.Header;
import com.bytezone.diskbrowser.infocom.ZString;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import java.util.ArrayList;
import java.util.List;

class Instruction {
    static int version = 3;
    final Opcode opcode;
    final int startPtr;
    private byte[] buffer;
    private Header header;
    static final String[] name2OP = new String[]{"*bad*", "je", "jl", "jg", "dec_chk", "inc_chk", "jin", "test", "or", "and", "test_attr", "set_attr", "clear_attr", "store", "insert_obj", "loadw", "loadb", "get_prop", "get_prop_addr", "get_next_prop", "add", "sub", "mul", "div", "mod", "call_2s", "call_2n", "set_colour", "throw", "*bad*", "*bad*", "*bad*"};
    static final String[] name1OP = new String[]{"jz", "get_sibling", "get_child", "get_parent", "get_prop_len", "inc", "dec", "print_addr", "call_ls", "remove_obj", "print_obj", "ret", "jump", "print_paddr", "load", "not"};
    static final String[] name0OP = new String[]{"rtrue", "rfalse", "print", "print_ret", "nop", "save", "restore", "restart", "ret_popped", "pop", "quit", "new_line", "show_status", "verify", "", "piracy"};
    static final String[] nameVAR = new String[]{"call", "storew", "storeb", "put_prop", "sread", "print_char", "print_num", "random", "push", "pull", "split_window", "set_window", "call_vs2", "erase_window", "erase_line", "set_cursor", "get_cursor", "set_text_style", "buffer_mode", "output_stream", "input_stream", "sound_effect", "read_char", "scan_table", "not", "call_vn", "call_vn2", "tokenise", "encode_text", "copy_table", "print_table", "check_arg"};

    Instruction(byte[] buffer, int ptr, Header header) {
        this.buffer = buffer;
        this.startPtr = ptr;
        this.header = header;
        byte b1 = buffer[ptr];
        int type = (b1 & 0xC0) >>> 6;
        switch (type) {
            case 3: {
                if ((b1 & 0x20) == 32) {
                    this.opcode = new OpcodeVar(buffer, ptr);
                    break;
                }
                this.opcode = new Opcode2OPVar(buffer, ptr);
                break;
            }
            case 2: {
                if (b1 == 190 && version >= 5) {
                    this.opcode = null;
                    break;
                }
                if ((b1 & 0x30) == 48) {
                    this.opcode = new Opcode0OP(buffer, ptr);
                    break;
                }
                this.opcode = new Opcode1OP(buffer, ptr);
                break;
            }
            default: {
                this.opcode = new Opcode2OPLong(buffer, ptr);
            }
        }
    }

    int length() {
        return this.opcode.length();
    }

    boolean isReturn() {
        return this.opcode.isReturn;
    }

    boolean isPrint() {
        return this.opcode.string != null;
    }

    boolean isCall() {
        return this.opcode.isCall;
    }

    boolean isJump() {
        return this.opcode instanceof Opcode1OP && this.opcode.opcodeNumber == 12;
    }

    boolean isBranch() {
        return this.opcode.branch != null;
    }

    boolean isStore() {
        return this.opcode.store != null;
    }

    int target() {
        return this.isBranch() ? this.opcode.branch.target : (this.isJump() ? this.opcode.jumpTarget : 0);
    }

    String dump() {
        return String.format("%05X : %s", this.startPtr, HexFormatter.getHexString(this.buffer, this.startPtr, this.opcode.length()));
    }

    String getHex() {
        int max = this.opcode.length();
        String extra = "";
        if (max > 9) {
            max = 9;
            extra = "..";
        }
        String hex = HexFormatter.getHexString(this.buffer, this.startPtr, max);
        return String.format("%05X : %-26s%2s", this.startPtr, hex, extra);
    }

    public String toString() {
        return this.opcode.toString();
    }

    class ArgumentBranch
    extends Operand {
        private int target;
        private boolean branchOnTrue;

        ArgumentBranch(byte value, int offset) {
            this.branchOnTrue = (value & 0x80) != 0;
            int val = value & 0x3F;
            this.target = val <= 1 ? val : val + offset - 1;
            this.length = 1;
            this.operandType = OperandType.ARG_BRANCH;
        }

        ArgumentBranch(int value, int offset) {
            this.branchOnTrue = (value & 0x8000) != 0;
            int val = (value & 0x3FFF) << 18 >> 18;
            this.target = val + offset;
            this.length = 2;
            this.operandType = OperandType.ARG_BRANCH;
        }

        @Override
        public String toString() {
            StringBuilder text = new StringBuilder();
            text.append(" [" + (this.branchOnTrue ? "true" : "false") + "] ");
            if (this.target == 0 || this.target == 1) {
                text.append(this.target == 0 ? "RFALSE" : "RTRUE");
            } else {
                text.append(String.format("%05X", this.target));
            }
            return text.toString();
        }
    }

    class ArgumentString
    extends Operand {
        private ZString text;
        private int startPtr;
        private byte[] buffer;

        ArgumentString(byte[] buffer, int offset) {
            this.buffer = buffer;
            this.text = new ZString(Instruction.this.header, offset);
            this.length = this.text.length;
            this.operandType = OperandType.ARG_STRING;
        }

        @Override
        public String toString() {
            return this.text.value;
        }
    }

    abstract class Opcode {
        int opcodeNumber;
        int opcodeLength;
        List<Operand> operands = new ArrayList<Operand>();
        int totalOperandLength;
        ArgumentBranch branch;
        ArgumentString string;
        OperandVariable store;
        boolean isReturn;
        boolean isCall;
        boolean isExit;
        int jumpTarget;
        int callTarget;

        Opcode() {
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            text.append(String.format("%-12s", this.opcodeName()));
            if (this.jumpTarget != 0) {
                text.append(String.format(" L:%05X", this.jumpTarget));
            } else if (this.isCall) {
                text.append(String.format(" R:%05X (", this.callTarget));
                int count = 0;
                for (Operand op : this.operands) {
                    if (count++ <= 0) continue;
                    text.append(op + ", ");
                }
                if (this.operands.size() > 1) {
                    text.delete(text.length() - 2, text.length());
                }
                text.append(") -> " + this.store);
            } else {
                for (Operand op : this.operands) {
                    text.append(" " + op);
                }
                if (this.branch != null) {
                    text.append(this.branch);
                }
                if (this.store != null) {
                    text.append(" -> " + this.store);
                }
                if (this.string != null) {
                    text.append(" \"" + this.string + "\"");
                }
            }
            return text.toString();
        }

        int length() {
            int length = this.totalOperandLength + this.opcodeLength;
            if (this.branch != null) {
                length += this.branch.length;
            }
            if (this.store != null) {
                length += this.store.length;
            }
            if (this.string != null) {
                length += this.string.length;
            }
            return length;
        }

        abstract String opcodeName();

        private void addOperand(Operand operand) {
            this.operands.add(operand);
            this.totalOperandLength += operand.length;
        }

        void addOperand(byte[] buffer, int ptr, boolean bit1, boolean bit2) {
            int offset = ptr + this.totalOperandLength;
            if (bit1) {
                if (!bit2) {
                    this.addOperand(new OperandVariable(buffer[offset]));
                }
            } else if (bit2) {
                this.addOperand(new OperandByte(buffer[offset]));
            } else {
                this.addOperand(new OperandWord(Instruction.this.header.getWord(offset)));
            }
        }

        void addOperand(byte[] buffer, int ptr, boolean bit) {
            int address = ptr + this.totalOperandLength;
            if (address >= buffer.length) {
                System.out.println("Illegal byte address : " + address);
                return;
            }
            if (bit) {
                this.addOperand(new OperandVariable(buffer[address]));
            } else {
                this.addOperand(new OperandByte(buffer[address]));
            }
        }

        void setVariableOperands(int ptr) {
            int value = Instruction.this.buffer[ptr + 1] & 0xFF;
            int i = 0;
            while (i < 4) {
                boolean bit2;
                boolean bit1 = (value & 0x80) == 128;
                boolean bl = bit2 = (value & 0x40) == 64;
                if (bit1 && bit2) break;
                this.addOperand(Instruction.this.buffer, ptr + 2, bit1, bit2);
                value <<= 2;
                ++i;
            }
        }

        void setStore(byte[] buffer) {
            this.store = new OperandVariable(buffer[Instruction.this.startPtr + this.totalOperandLength + this.opcodeLength]);
        }

        void setBranch(byte[] buffer) {
            int offset = Instruction.this.startPtr + this.totalOperandLength + (this.store == null ? 0 : 1) + this.opcodeLength;
            this.branch = (buffer[offset] & 0x40) != 0 ? new ArgumentBranch(buffer[offset], offset) : new ArgumentBranch(Instruction.this.header.getWord(offset), offset);
        }

        void setZString(byte[] buffer) {
            int offset = Instruction.this.startPtr + this.totalOperandLength + this.opcodeLength;
            this.string = new ArgumentString(buffer, offset);
        }
    }

    class Opcode0OP
    extends Opcode {
        Opcode0OP(byte[] buffer, int ptr) {
            this.opcodeNumber = buffer[ptr] & 0xF;
            this.opcodeLength = 1;
            if (this.opcodeNumber == 5 || this.opcodeNumber == 6 || this.opcodeNumber == 13) {
                this.setBranch(buffer);
            }
            if (this.opcodeNumber == 0 || this.opcodeNumber == 1 || this.opcodeNumber == 3 || this.opcodeNumber == 8) {
                this.isReturn = true;
            }
            if (this.opcodeNumber == 2 || this.opcodeNumber == 3) {
                this.setZString(buffer);
            }
            if (this.opcodeNumber == 7 || this.opcodeNumber == 10) {
                this.isExit = true;
            }
        }

        @Override
        public String opcodeName() {
            return name0OP[this.opcodeNumber];
        }
    }

    class Opcode1OP
    extends Opcode {
        Opcode1OP(byte[] buffer, int ptr) {
            this.opcodeNumber = buffer[ptr] & 0xF;
            this.opcodeLength = 1;
            boolean bit1 = (buffer[ptr] & 0x20) == 32;
            boolean bit2 = (buffer[ptr] & 0x10) == 16;
            this.addOperand(buffer, ptr + 1, bit1, bit2);
            if (this.opcodeNumber >= 1 && this.opcodeNumber <= 4 || this.opcodeNumber == 8 || this.opcodeNumber == 14 || this.opcodeNumber == 15) {
                this.setStore(buffer);
            }
            if (this.opcodeNumber <= 2) {
                this.setBranch(buffer);
            }
            if (this.opcodeNumber == 12) {
                this.jumpTarget = (short)((Operand)this.operands.get((int)0)).value + Instruction.this.startPtr - 2 + this.length();
            }
            if (this.opcodeNumber == 11) {
                this.isReturn = true;
            }
        }

        @Override
        public String opcodeName() {
            return name1OP[this.opcodeNumber];
        }
    }

    abstract class Opcode2OP
    extends Opcode {
        Opcode2OP() {
            this.opcodeLength = 1;
        }

        void setArguments(byte[] buffer) {
            if (this.opcodeNumber >= 1 && this.opcodeNumber <= 7 || this.opcodeNumber == 10) {
                this.setBranch(buffer);
            } else if (this.opcodeNumber >= 15 && this.opcodeNumber <= 25 || this.opcodeNumber == 8 || this.opcodeNumber == 9) {
                this.setStore(buffer);
            }
        }

        @Override
        public String opcodeName() {
            return name2OP[this.opcodeNumber];
        }
    }

    class Opcode2OPLong
    extends Opcode2OP {
        Opcode2OPLong(byte[] buffer, int ptr) {
            boolean bit2;
            this.opcodeNumber = buffer[ptr] & 0x1F;
            boolean bit1 = (buffer[ptr] & 0x40) == 64;
            boolean bl = bit2 = (buffer[ptr] & 0x20) == 32;
            if (this.opcodeNumber == 13) {
                this.addOperand(buffer, ptr + 1, true);
                this.addOperand(buffer, ptr + 1, bit2);
            } else {
                this.addOperand(buffer, ptr + 1, bit1);
                this.addOperand(buffer, ptr + 1, bit2);
            }
            this.setArguments(buffer);
        }
    }

    class Opcode2OPVar
    extends Opcode2OP {
        Opcode2OPVar(byte[] buffer, int ptr) {
            this.opcodeNumber = buffer[ptr] & 0x1F;
            this.opcodeLength = 2;
            this.setVariableOperands(ptr);
            this.setArguments(buffer);
        }
    }

    class OpcodeVar
    extends Opcode {
        OpcodeVar(byte[] buffer, int ptr) {
            this.opcodeNumber = buffer[ptr] & 0x1F;
            this.opcodeLength = 2;
            this.setVariableOperands(ptr);
            if (this.opcodeNumber == 0 || this.opcodeNumber == 7) {
                this.setStore(buffer);
            }
            if (this.opcodeNumber == 0) {
                this.isCall = true;
                this.callTarget = ((Operand)this.operands.get((int)0)).value * 2;
            }
            if (this.opcodeNumber == 3) {
                ((Operand)this.operands.get((int)0)).operandType = OperandType.OBJECT;
            }
        }

        @Override
        public String opcodeName() {
            return nameVAR[this.opcodeNumber];
        }
    }

    abstract class Operand {
        int length;
        int value;
        OperandType operandType;

        Operand() {
        }

        public String toString() {
            switch (this.operandType) {
                case VAR_SP: {
                    return "(SP)";
                }
                case VAR_LOCAL: {
                    return String.format("L%02X", this.value - 1);
                }
                case VAR_GLOBAL: {
                    return String.format("G%02X", this.value - 16);
                }
                case BYTE: {
                    return String.format("#%02X", this.value);
                }
                case WORD: {
                    return String.format("#%04X", this.value);
                }
                case OBJECT: {
                    return "\"" + Instruction.this.header.objectManager.getObject(this.value - 1).getName() + "\"";
                }
            }
            return "*** Illegal ***";
        }
    }

    class OperandByte
    extends Operand {
        OperandByte(byte value) {
            this.value = value & 0xFF;
            this.length = 1;
            this.operandType = OperandType.BYTE;
        }
    }

    static enum OperandType {
        VAR_SP,
        VAR_LOCAL,
        VAR_GLOBAL,
        BYTE,
        WORD,
        ARG_BRANCH,
        ARG_STRING,
        OBJECT;

    }

    class OperandVariable
    extends Operand {
        OperandVariable(byte value) {
            this.value = value & 0xFF;
            this.length = 1;
            this.operandType = this.value == 0 ? OperandType.VAR_SP : (this.value <= 15 ? OperandType.VAR_LOCAL : OperandType.VAR_GLOBAL);
        }
    }

    class OperandWord
    extends Operand {
        OperandWord(int value) {
            this.value = value;
            this.length = 2;
            this.operandType = OperandType.WORD;
        }
    }
}

